/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.dpc;

import eu.unicore.uftp.dpc.AuthorizationCheck;
import eu.unicore.uftp.dpc.AuthorizationFailureException;
import eu.unicore.uftp.dpc.DPCServer;
import eu.unicore.uftp.dpc.ProtocolViolationException;
import eu.unicore.uftp.dpc.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class DPCClient {
    private static final Logger logger = Logger.getLogger(DPCClient.class);
    private int timeout;
    private int authTimeout;
    private Socket controlSocket;
    private Socket[] dataSockets = null;
    private volatile boolean connected = false;
    private BufferedWriter controlWriter;
    private BufferedReader controlReader;
    protected static final String[] requests = new String[]{"USER anonymous\r\n", "USER anonymous\r\n", "SYST\r\n"};
    private final List<String> features = new ArrayList<String>();

    public void connect(InetAddress[] server, int port, AuthorizationCheck auth) throws IOException, ProtocolViolationException, AuthorizationFailureException {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        InetAddress selectedServer = null;
        StringBuilder errors = new StringBuilder();
        for (InetAddress s : server) {
            try {
                this.controlSocket = new Socket(s, port);
                selectedServer = s;
                this.tryConnect(auth);
                logger.info("Connected to server at IP: " + selectedServer.getHostAddress() + " port: " + port);
                break;
            }
            catch (Exception ex) {
                try {
                    if (this.controlSocket != null) {
                        this.controlSocket.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                errors.append("[").append(Utils.createFaultMessage(s.toString(), ex)).append("]");
            }
        }
        if (!this.connected) {
            throw new IOException("Can't connect to server " + Arrays.asList(server) + " at port " + port + ". Error message " + errors);
        }
        logger.info("Connected to server at IP: " + selectedServer.getHostAddress() + " port: " + port);
    }

    private void tryConnect(AuthorizationCheck auth) throws IOException, ProtocolViolationException, AuthorizationFailureException {
        this.controlWriter = new BufferedWriter(new OutputStreamWriter(this.controlSocket.getOutputStream()));
        this.controlReader = new BufferedReader(new InputStreamReader(this.controlSocket.getInputStream()));
        String response = "";
        response = this.readControl();
        if (response == null) {
            throw new IOException("The connection was refused by the UFTPD server. Please check the client IP and other parameters.");
        }
        if (!response.startsWith("220")) {
            throw new ProtocolViolationException("Code '220' expected, got " + response);
        }
        for (int i = 0; i < requests.length; ++i) {
            this.sendControl(requests[i]);
            response = this.readControl();
            if (DPCServer.responses[i + 1].equals(response + "\r\n")) continue;
            String err = "'" + response + "' does not comply with protocol.";
            this.sendControl("500 " + err + "\r\n");
            throw new ProtocolViolationException(err);
        }
        this.sendControl("FEAT\r\n");
        response = this.readControl();
        if (!response.startsWith("211")) {
            throw new ProtocolViolationException("Expected 211 reply.");
        }
        while (true) {
            if ((response = this.readControl()) == null || this.features.size() > 21) {
                throw new ProtocolViolationException("Illegal server reply");
            }
            if ("211 END".equals(response)) break;
            this.features.add(response.trim());
        }
        System.out.println("Features: " + this.features);
        if (!"PASV".equals(this.features.get(0))) {
            throw new ProtocolViolationException("Illegal server reply, missing PASV feature");
        }
        Socket authSocket = this.getNewConnection();
        Object res = auth.isAuthorized(authSocket);
        if (Boolean.TRUE != res) {
            authSocket.close();
            this.controlSocket.close();
            throw new AuthorizationFailureException(String.valueOf(res));
        }
        authSocket.close();
        this.connected = true;
    }

    public Socket[] openDataConnections(int numParCons) throws IOException, ProtocolViolationException {
        this.checkConnected();
        if (this.dataSockets != null) {
            throw new IllegalStateException("There are already open data connections.");
        }
        String noopMsg = "NOOP " + numParCons + "\r\n";
        this.controlWriter.write(noopMsg);
        this.controlWriter.flush();
        logger.debug(noopMsg);
        String noopResponse = this.controlReader.readLine();
        if (noopResponse.startsWith("223")) {
            numParCons = Integer.parseInt(noopResponse.split(" ")[2]);
        }
        logger.debug(noopResponse);
        this.dataSockets = new Socket[numParCons];
        for (int i = 0; i < this.dataSockets.length; ++i) {
            this.dataSockets[i] = this.getNewConnection();
        }
        return this.dataSockets;
    }

    private Socket getNewConnection() throws IOException {
        String pasvMsg = "PASV\r\n";
        logger.debug("-> " + pasvMsg);
        this.sendControl(pasvMsg);
        String inputLine = this.readControl();
        String[] inputString = inputLine.split(" ")[4].substring(1).split(",");
        InetAddress dataAddress = InetAddress.getByName(inputString[0] + "." + inputString[1] + "." + inputString[2] + "." + inputString[3]);
        int dataPort = Integer.parseInt(inputString[4]) * 256 + Integer.parseInt(inputString[5].substring(0, inputString[5].length() - 1));
        return new Socket(dataAddress, dataPort);
    }

    public void closeData() throws IOException {
        for (int i = 0; i < this.dataSockets.length; ++i) {
            this.dataSockets[i].close();
        }
        this.dataSockets = null;
    }

    public void close() throws IOException {
        this.closeData();
        this.controlSocket.close();
        this.connected = false;
        logger.info("Connection closed.");
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getAuthTimeout() {
        return this.authTimeout;
    }

    public void setAuthTimeout(int authTimeout) {
        this.authTimeout = authTimeout;
    }

    public void sendControl(String message) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("--> " + message.trim());
        }
        this.controlWriter.write(message);
        this.controlWriter.flush();
    }

    public String readControl() throws IOException {
        String res = this.controlReader.readLine();
        if (logger.isDebugEnabled()) {
            logger.debug("<-- " + res.trim());
        }
        return res;
    }

    public final List<String> getFeatures() {
        this.checkConnected();
        return this.features;
    }

    private void checkConnected() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
    }
}

