/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil.client;

import eu.unicore.security.xfireutil.DSigDecider;
import java.util.Set;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.addressing.AddressingOperationInfo;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.soap.AbstractSoapBinding;

public class ContextDSigDecider
implements DSigDecider {
    public static final String SIGN_MESSAGE = ContextDSigDecider.class.getName() + "doSign";
    public static final String SIGNED_OPERATIONS = ContextDSigDecider.class.getName() + "signedOperations";

    @Override
    public boolean isMessageDSigCandidate(MessageContext ctx) {
        if (Boolean.TRUE.equals(ctx.getProperty("client.mode"))) {
            return this.clientCall(ctx);
        }
        return false;
    }

    private boolean clientCall(MessageContext ctx) {
        if (Boolean.TRUE.equals(ctx.getProperty(SIGN_MESSAGE))) {
            return true;
        }
        Client client = ctx.getClient();
        Set signedOperations = (Set)client.getProperty(SIGNED_OPERATIONS);
        if (signedOperations == null) {
            return false;
        }
        OperationInfo oi = ctx.getExchange().getOperation();
        AddressingOperationInfo aoi = (AddressingOperationInfo)oi.getProperty("addressingOperationInfo");
        if (aoi == null) {
            if (ctx.getBinding() instanceof AbstractSoapBinding) {
                String action = ((AbstractSoapBinding)ctx.getBinding()).getSoapAction(oi);
                if (action == null) {
                    return false;
                }
                return signedOperations.contains(action);
            }
            return false;
        }
        String action = aoi.getInAction();
        if (action == null) {
            return false;
        }
        return signedOperations.contains(action);
    }
}

