/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil;

import eu.unicore.security.dsig.DOMUtilities;
import eu.unicore.security.xfireutil.DSigDecider;
import eu.unicore.security.xfireutil.client.LogInMessageHandler;
import eu.unicore.util.Log;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.soap.handler.ReadHeadersHandler;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.util.stax.W3CDOMStreamReader2;
import org.w3c.dom.Document;

public class DSigParseInHandler
extends AbstractHandler {
    protected static final Logger logger = Log.getLogger("unicore.security.dsig", DSigParseInHandler.class);
    public static final String DOCUMENT_DOM_KEY = DSigParseInHandler.class.getName() + "_DOM";
    private DSigDecider decider;

    public DSigParseInHandler(DSigDecider decider) {
        this.setPhase("parse");
        this.before(ReadHeadersHandler.class.getName());
        this.before(LogInMessageHandler.class.getName());
        this.decider = decider;
    }

    @Override
    public void invoke(MessageContext ctx) throws Exception {
        if (this.decider == null || this.decider.isMessageDSigCandidate(ctx)) {
            this.buildDOM(ctx);
        }
    }

    protected void buildDOM(MessageContext ctx) throws XMLStreamException, ParserConfigurationException {
        Document doc;
        logger.debug("Creating DOM from SOAP message");
        long start = System.currentTimeMillis();
        InMessage msg = ctx.getInMessage();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            doc = STAXUtils.read(dbf.newDocumentBuilder(), msg.getXMLStreamReader(), false);
        }
        catch (XMLStreamException e1) {
            logger.warn("Can't parse XML stream as W3C DOM: " + e1.getMessage());
            throw e1;
        }
        catch (ParserConfigurationException e1) {
            logger.warn("Can't create W3C DOM document builder: " + e1.getMessage());
            throw e1;
        }
        if (logger.isTraceEnabled()) {
            DOMUtilities.logDOMAsRawString("SOAP message DOM is: \n", doc, logger);
        }
        W3CDOMStreamReader2 replayStream = new W3CDOMStreamReader2(doc.getDocumentElement());
        msg.setXMLStreamReader(replayStream);
        ctx.setProperty(DOCUMENT_DOM_KEY, doc);
        long stop = System.currentTimeMillis();
        logger.debug("DOM creation time: " + (stop - start));
    }
}

