/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.dsig;

import eu.unicore.samly2.assertion.AbstractAssertion;
import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.security.dsig.DigSignatureUtil;
import java.io.FileInputStream;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public class AssertionSignatureChecker {
    private DocumentBuilder documentBuilder;

    public AssertionSignatureChecker() throws Exception {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        dfactory.setValidating(false);
        this.documentBuilder = dfactory.newDocumentBuilder();
    }

    public static void main(String[] args) {
        try {
            AssertionSignatureChecker checker = new AssertionSignatureChecker();
            DigSignatureUtil dsigEngine = new DigSignatureUtil();
            Document doc = checker.readDoc(null);
            AssertionDocument asXDoc = AssertionDocument.Factory.parse(doc);
            Assertion assertion = new Assertion(asXDoc);
            X509Certificate[] certChain = assertion.getIssuerFromSignature();
            if (certChain == null || certChain.length == 0) {
                System.err.println("Can't read issuer certificate from the assertion.");
                return;
            }
            PublicKey pubKey = certChain[0].getPublicKey();
            boolean res = dsigEngine.verifyEnvelopedSignature(doc, Collections.singletonList(doc.getDocumentElement()), AbstractAssertion.ASSERTION_ID_QNAME, pubKey);
            System.out.println("Signature is valid: " + res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Document readDoc(String file) throws Exception {
        if (file == null) {
            Document inputDoc = this.documentBuilder.parse(System.in);
            return inputDoc;
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            Document inputDoc;
            Document document = inputDoc = this.documentBuilder.parse(fis);
            return document;
        }
        finally {
            fis.close();
        }
    }
}

