/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.consignor;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.SAMLConstants;
import eu.unicore.security.ValidationResult;
import eu.unicore.security.consignor.ConsignorAPI;
import eu.unicore.security.consignor.ConsignorAssertion;
import eu.unicore.security.dsig.DSigException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import xmlbeans.org.oasis.saml2.assertion.AuthnContextDocument;
import xmlbeans.org.oasis.saml2.assertion.SubjectLocalityDocument;
import xmlbeans.org.oasis.saml2.assertion.SubjectLocalityType;

public class ConsignorImpl
implements ConsignorAPI {
    @Override
    public ConsignorAssertion generateConsignorToken(String issuerDN, X509Certificate[] consignorCert, PrivateKey pk, int negativeTolerance, int validity, SAMLConstants.AuthNClasses acClass, String ip) throws DSigException {
        ConsignorAssertion assertion = new ConsignorAssertion();
        assertion.setX509Issuer(issuerDN);
        if (consignorCert != null) {
            assertion.setX509Subject(consignorCert[0].getSubjectX500Principal().getName());
            try {
                assertion.setSenderVouchesX509Confirmation(consignorCert);
            }
            catch (CertificateEncodingException e) {
                throw new DSigException(e);
            }
        } else {
            assertion.setX509Subject("CN=ANONYMOUS,O=UNKNOWN,OU=UNKNOWN");
        }
        Calendar cur = Calendar.getInstance();
        if (acClass.equals((Object)SAMLConstants.AuthNClasses.TLS)) {
            AuthnContextDocument dummyCtx = AuthnContextDocument.Factory.newInstance();
            SubjectLocalityDocument locDoc = SubjectLocalityDocument.Factory.newInstance();
            SubjectLocalityType loc = locDoc.addNewSubjectLocality();
            loc.setAddress(ip);
            assertion.addAuthStatement(cur, dummyCtx.addNewAuthnContext(), null, null, loc);
        }
        Date notBefore = null;
        Date notOnOrAfter = null;
        if (negativeTolerance >= 0) {
            cur.add(13, -negativeTolerance);
            notBefore = cur.getTime();
        }
        if (validity >= 0) {
            cur.add(13, validity);
            notOnOrAfter = cur.getTime();
        }
        if (notBefore != null || notOnOrAfter != null) {
            assertion.setTimeConditions(notBefore, notOnOrAfter);
        }
        if (pk != null) {
            assertion.sign(pk);
        }
        return assertion;
    }

    @Override
    public ValidationResult verifyConsignorToken(ConsignorAssertion assertion, X509Certificate issuerCertificate) {
        String i1 = assertion.getIssuerDN();
        X500Principal i2 = issuerCertificate.getSubjectX500Principal();
        if (!X500NameUtils.equal(i2, i1)) {
            return new ValidationResult(false, "Wrong issuer");
        }
        if (!assertion.checkTimeConditions()) {
            return new ValidationResult(false, "Lifetime conditions are not met");
        }
        try {
            if (assertion.isSigned() && !assertion.isCorrectlySigned(issuerCertificate.getPublicKey())) {
                return new ValidationResult(false, "Signature is invalid");
            }
        }
        catch (DSigException e) {
            return new ValidationResult(false, e.getMessage());
        }
        return new ValidationResult(true, "OK");
    }

    @Override
    public ConsignorAssertion generateConsignorToken(String issuerDN, X509Certificate[] consignorCert, SAMLConstants.AuthNClasses acClass, String ip) throws DSigException {
        return this.generateConsignorToken(issuerDN, consignorCert, null, -1, -1, acClass, ip);
    }

    @Override
    public ConsignorAssertion generateConsignorToken(String issuerDN, int negativeTolerance, int validity, PrivateKey pk, String ip) throws DSigException {
        return this.generateConsignorToken(issuerDN, null, pk, negativeTolerance, validity, SAMLConstants.AuthNClasses.NONE, ip);
    }

    @Override
    public ConsignorAssertion generateConsignorToken(String issuerDN) {
        try {
            return this.generateConsignorToken(issuerDN, null, null, -1, -1, SAMLConstants.AuthNClasses.NONE, null);
        }
        catch (DSigException e) {
            return null;
        }
    }
}

