/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.consignor;

import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.samly2.exceptions.SAMLParseException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlException;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AttributeStatementType;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;

public class ConsignorAssertion
extends Assertion {
    private static final long serialVersionUID = 9087483370558929619L;
    public static final String CONSIGNOR_ROLE = "CONSIGNOR";
    public static final String ROLE_NAME_FORMAT = "urn:unicore:subject-role";

    public ConsignorAssertion() {
        SAMLAttribute attribute = new SAMLAttribute(CONSIGNOR_ROLE, ROLE_NAME_FORMAT);
        this.addAttribute(attribute);
    }

    public ConsignorAssertion(AssertionDocument doc) throws SAMLParseException, XmlException, IOException {
        super(doc);
        boolean found = false;
        AttributeStatementType[] attrSs = this.getAttributes();
        if (attrSs == null) {
            throw new SAMLParseException("No attribute statement in SAML assertion");
        }
        int i = 0;
        while (i < attrSs.length) {
            AttributeType[] attrs = attrSs[i].getAttributeArray();
            int j = 0;
            while (j < attrs.length) {
                if (attrs[j].getName().equals(CONSIGNOR_ROLE) && attrs[j].getNameFormat().equals(ROLE_NAME_FORMAT)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (found) break;
            ++i;
        }
        if (!found) {
            throw new SAMLParseException("SAML assertion doesn't contain consignor role attirbute");
        }
    }

    public X509Certificate[] getConsignor() {
        return this.getSubjectFromConfirmation();
    }
}

