/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.canl;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.OCSPResponder;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.impl.CRLParameters;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.DirectoryCertChainValidator;
import eu.emi.security.authn.x509.impl.KeystoreCertChainValidator;
import eu.emi.security.authn.x509.impl.KeystoreCredential;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.RevocationParametersExt;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import eu.emi.security.authn.x509.impl.ValidatorParamsExt;
import eu.unicore.security.canl.PasswordCallback;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyChangeListener;
import eu.unicore.util.configuration.PropertyMD;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TruststoreProperties
extends PropertiesHelper {
    private static final Logger log = Log.getLogger("unicore.configuration", TruststoreProperties.class);
    public static final String DEFAULT_PREFIX = "truststore.";
    public static final String PROP_TYPE = "type";
    public static final String PROP_UPDATE = "updateInterval";
    public static final String PROP_PROXY_SUPPORT = "allowProxy";
    public static final String PROP_CRL_MODE = "crlMode";
    public static final String PROP_OCSP_MODE = "ocspMode";
    public static final String PROP_OCSP_TIMEOUT = "ocspTimeout";
    public static final String PROP_OCSP_CACHE_TTL = "ocspCacheTtl";
    public static final String PROP_OCSP_DISK_CACHE = "ocspDiskCache";
    public static final String PROP_OCSP_LOCAL_RESPONDERS = "ocspLocalResponders.";
    public static final String PROP_REVOCATION_ORDER = "revocationOrder";
    public static final String PROP_REVOCATION_USE_ALL = "revocationUseAll";
    public static final String PROP_CRL_LOCATIONS = "crlLocations.";
    public static final String PROP_CRL_UPDATE = "crlUpdateInterval";
    public static final String PROP_CRL_CONNECTION_TIMEOUT = "crlConnectionTimeout";
    public static final String PROP_CRL_CACHE_PATH = "crlDiskCachePath";
    public static final String PROP_KS_PATH = "keystorePath";
    public static final String PROP_KS_PASSWORD = "keystorePassword";
    public static final String PROP_KS_TYPE = "keystoreFormat";
    public static final String PROP_OPENSSL_DIR = "opensslPath";
    public static final String PROP_OPENSSL_NS_MODE = "opensslNsMode";
    public static final String PROP_DIRECTORY_LOCATIONS = "directoryLocations.";
    public static final String PROP_DIRECTORY_ENCODING = "directoryEncoding";
    public static final String PROP_DIRECTORY_CONNECTION_TIMEOUT = "directoryConnectionTimeout";
    public static final String PROP_DIRECTORY_CACHE_PATH = "directoryDiskCachePath";
    private Collection<? extends StoreUpdateListener> initialListeners;
    private OpensslCertChainValidator opensslValidator = null;
    private DirectoryCertChainValidator directoryValidator = null;
    private KeystoreCertChainValidator ksValidator = null;
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();
    private TruststoreType type;
    private ProxySupport proxySupport;
    private CrlCheckingMode crlMode;
    private long storeUpdateInterval;
    private NamespaceCheckingMode nsMode;
    private String opensslDir;
    private long crlUpdateInterval;
    private int crlConnectionTimeout;
    private String crlDiskCache;
    private List<String> crlLocations;
    private CertificateUtils.Encoding directoryEncoding;
    private List<String> directoryLocations;
    private int caConnectionTimeout;
    private String caDiskCache;
    private String ksPath;
    private String ksType;
    private PasswordCallback passwordCallback;

    static {
        PropertyMD.DocumentationCategory dirCat = new PropertyMD.DocumentationCategory("Directory type settings", "1");
        PropertyMD.DocumentationCategory ksCat = new PropertyMD.DocumentationCategory("Keystore type settings", "2");
        PropertyMD.DocumentationCategory opensslCat = new PropertyMD.DocumentationCategory("Openssl type settings", "3");
        PropertyMD.DocumentationCategory revCat = new PropertyMD.DocumentationCategory("Revocation settings", "4");
        META.put(PROP_TYPE, new PropertyMD().setEnum(TruststoreType.directory).setMandatory().setDescription("The truststore type."));
        META.put(PROP_PROXY_SUPPORT, new PropertyMD(ProxySupport.ALLOW).setDescription("Controls whether proxy certificates are supported."));
        META.put(PROP_UPDATE, new PropertyMD("600").setLong().setUpdateable().setDescription("How often the truststore should be reloaded, in seconds. Set to negative value to disable refreshing at runtime."));
        META.put(PROP_KS_PASSWORD, new PropertyMD().setSecret().setCategory(ksCat).setDescription("The password of the keystore type truststore."));
        META.put(PROP_KS_TYPE, new PropertyMD().setCategory(ksCat).setDescription("The keystore type (jks, pkcs12) in case of truststore of keystore type."));
        META.put(PROP_KS_PATH, new PropertyMD().setCategory(ksCat).setDescription("The keystore path in case of truststore of keystore type."));
        META.put(PROP_OPENSSL_NS_MODE, new PropertyMD(NamespaceCheckingMode.EUGRIDPMA_GLOBUS).setCategory(opensslCat).setDescription("In case of openssl truststore, controls which (and in which order) namespace checking rules should be applied. The 'REQUIRE' settings will cause that all configured namespace definitions files must be present for each trusted CA certificate (otherwise checking will fail). The 'AND' settings will cause to check both existing namespace files. Otherwise the first found is checked (in the order defined by the property)."));
        META.put(PROP_OPENSSL_DIR, new PropertyMD("/etc/grid-security/certificates").setPath().setCategory(opensslCat).setDescription("Directory to be used for opeenssl truststore."));
        META.put(PROP_DIRECTORY_LOCATIONS, new PropertyMD().setList(false).setUpdateable().setCategory(dirCat).setDescription("List of CA certificates locations. Can contain URLs, local files and wildcard expressions."));
        META.put(PROP_DIRECTORY_ENCODING, new PropertyMD(CertificateUtils.Encoding.PEM).setCategory(dirCat).setDescription("For directory truststore controls whether certificates are encoded in PEM or DER."));
        META.put(PROP_DIRECTORY_CONNECTION_TIMEOUT, new PropertyMD("15").setCategory(dirCat).setDescription("Connection timeout for fetching the remote CA certificates in seconds."));
        META.put(PROP_DIRECTORY_CACHE_PATH, new PropertyMD().setPath().setCategory(dirCat).setDescription("Directory where CA certificates should be cached, after downloading them from a remote source. Can be left undefined if no disk cache should be used. Note that directory should be secured, i.e. normal users should not be allowed to write to it."));
        META.put(PROP_REVOCATION_ORDER, new PropertyMD(RevocationParameters.RevocationCheckingOrder.OCSP_CRL).setCategory(revCat).setDescription("Controls overal revocation sources order"));
        META.put(PROP_REVOCATION_USE_ALL, new PropertyMD("false").setCategory(revCat).setDescription("Controls whether all defined revocation sources should be always checked, even if the first one already confirmed that a checked certificate is not revoked."));
        META.put(PROP_CRL_MODE, new PropertyMD(CrlCheckingMode.IF_VALID).setCategory(revCat).setDescription("General CRL handling mode. The IF_VALID setting turns on CRL checking only in case the CRL is present."));
        META.put(PROP_CRL_UPDATE, new PropertyMD("600").setLong().setUpdateable().setCategory(revCat).setDescription("How often CRLs should be updated, in seconds. Set to negative value to disable refreshing at runtime."));
        META.put(PROP_CRL_CONNECTION_TIMEOUT, new PropertyMD("15").setCategory(revCat).setDescription("Connection timeout for fetching the remote CRLs in seconds (not used for Openssl truststores)."));
        META.put(PROP_CRL_CACHE_PATH, new PropertyMD().setPath().setCategory(revCat).setDescription("Directory where CRLs should be cached, after downloading them from remote source. Can be left undefined if no disk cache should be used. Note that directory should be secured, i.e. normal users should not be allowed to write to it. Not used for Openssl truststores."));
        META.put(PROP_CRL_LOCATIONS, new PropertyMD().setList(false).setUpdateable().setCategory(revCat).setDescription("List of CRLs locations. Can contain URLs, local files and wildcard expressions. Not used for Openssl truststores."));
        META.put(PROP_OCSP_MODE, new PropertyMD(OCSPCheckingMode.IF_AVAILABLE).setCategory(revCat).setDescription("General OCSP ckecking mode. REQUIRE should not be used unless it is guaranteed that for all certificates an OCSP responder is defined."));
        META.put(PROP_OCSP_LOCAL_RESPONDERS, new PropertyMD().setList(true).setCategory(revCat).setDescription("Optional list of local OCSP responders"));
        META.put(PROP_OCSP_TIMEOUT, new PropertyMD("10000").setCategory(revCat).setDescription("Timeout for OCSP connections in miliseconds."));
        META.put(PROP_OCSP_CACHE_TTL, new PropertyMD("3600").setCategory(revCat).setDescription("For how long the OCSP responses should be locally cached in seconds (this is a maximum value, responses won't be cached after expiration)"));
        META.put(PROP_OCSP_DISK_CACHE, new PropertyMD().setPath().setCategory(revCat).setDescription("If this property is defined then OCSP responses will be cached on disk in the defined folder."));
    }

    public TruststoreProperties(Properties properties, Collection<? extends StoreUpdateListener> initialListeners) throws ConfigurationException {
        this(properties, initialListeners, null, DEFAULT_PREFIX);
    }

    public TruststoreProperties(Properties properties, Collection<? extends StoreUpdateListener> initialListeners, PasswordCallback callback) throws ConfigurationException {
        this(properties, initialListeners, callback, DEFAULT_PREFIX);
    }

    public TruststoreProperties(Properties properties, Collection<? extends StoreUpdateListener> initialListeners, String pfx) throws ConfigurationException {
        this(properties, initialListeners, null, pfx);
    }

    public TruststoreProperties(Properties properties, Collection<? extends StoreUpdateListener> initialListeners, PasswordCallback callback, String pfx) throws ConfigurationException {
        super(pfx, properties, META, log);
        this.initialListeners = initialListeners;
        this.passwordCallback = callback;
        this.createValidatorSafe();
        this.addPropertyChangeListener(new PropertyChangeListenerImpl());
    }

    public X509CertChainValidatorExt getValidator() {
        if (this.type.equals((Object)TruststoreType.keystore)) {
            return this.ksValidator;
        }
        if (this.type.equals((Object)TruststoreType.openssl)) {
            return this.opensslValidator;
        }
        if (this.type.equals((Object)TruststoreType.directory)) {
            return this.directoryValidator;
        }
        throw new RuntimeException("BUG: not all truststore types are handled in the code");
    }

    protected void update(String property) throws ConfigurationException {
        List<String> newDirectoryLocations;
        List<String> newCrlLocations;
        long newCrlUpdateInterval;
        long newUpdateInterval;
        if (property.equals(PROP_UPDATE) && (newUpdateInterval = this.getLongValue(PROP_UPDATE).longValue()) != this.storeUpdateInterval) {
            if (this.opensslValidator != null) {
                this.opensslValidator.setUpdateInterval(newUpdateInterval * 1000L);
            }
            if (this.directoryValidator != null) {
                this.directoryValidator.setTruststoreUpdateInterval(newUpdateInterval * 1000L);
            }
            if (this.ksValidator != null) {
                this.ksValidator.setTruststoreUpdateInterval(newUpdateInterval * 1000L);
            }
            this.storeUpdateInterval = newUpdateInterval;
            log.info("Updated " + this.prefix + PROP_UPDATE + " value to " + this.storeUpdateInterval);
        }
        if (this.opensslValidator != null) {
            return;
        }
        if (property.equals(PROP_CRL_UPDATE) && (newCrlUpdateInterval = this.getLongValue(PROP_CRL_UPDATE).longValue()) != this.crlUpdateInterval) {
            if (this.directoryValidator != null) {
                this.directoryValidator.setCRLUpdateInterval(newCrlUpdateInterval * 1000L);
            }
            if (this.ksValidator != null) {
                this.ksValidator.setCRLUpdateInterval(newCrlUpdateInterval * 1000L);
            }
            this.crlUpdateInterval = newCrlUpdateInterval;
            log.info("Updated " + this.prefix + PROP_CRL_UPDATE + " value to " + this.crlUpdateInterval);
        }
        if (property.startsWith(PROP_CRL_LOCATIONS) && !(newCrlLocations = this.getListOfValues(PROP_CRL_LOCATIONS)).equals(this.crlLocations)) {
            if (this.directoryValidator != null) {
                this.directoryValidator.setCrls(newCrlLocations);
            }
            if (this.ksValidator != null) {
                this.ksValidator.setCrls(newCrlLocations);
            }
            this.crlLocations = newCrlLocations;
            log.info("Updated " + this.prefix + PROP_CRL_LOCATIONS);
        }
        if (this.ksValidator != null) {
            return;
        }
        if (property.startsWith(PROP_DIRECTORY_LOCATIONS) && !(newDirectoryLocations = this.getListOfValues(PROP_DIRECTORY_LOCATIONS)).equals(this.directoryLocations)) {
            this.directoryValidator.setTruststorePaths(newDirectoryLocations);
            this.directoryLocations = newDirectoryLocations;
            log.info("Updated " + this.prefix + PROP_DIRECTORY_LOCATIONS);
        }
    }

    private void createValidatorSafe() throws ConfigurationException {
        try {
            this.createValidator();
        }
        catch (KeyStoreException e) {
            throw new ConfigurationException("There was a problem setting up the truststore of type " + (Object)((Object)this.type) + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ConfigurationException("There was a problem setting up the truststore of type " + (Object)((Object)this.type) + ": " + e.getMessage(), e);
        }
    }

    private void createValidator() throws ConfigurationException, KeyStoreException, IOException {
        this.type = this.getEnumValue(PROP_TYPE, TruststoreType.class);
        this.storeUpdateInterval = this.getLongValue(PROP_UPDATE);
        this.crlMode = this.getEnumValue(PROP_CRL_MODE, CrlCheckingMode.class);
        this.proxySupport = this.getEnumValue(PROP_PROXY_SUPPORT, ProxySupport.class);
        if (this.type.equals((Object)TruststoreType.keystore)) {
            this.ksValidator = this.getKeystoreValidator();
        } else if (this.type.equals((Object)TruststoreType.openssl)) {
            this.opensslValidator = this.getOpensslValidator();
        } else if (this.type.equals((Object)TruststoreType.directory)) {
            this.directoryValidator = this.getDirectoryValidator();
        }
    }

    private DirectoryCertChainValidator getDirectoryValidator() throws ConfigurationException, KeyStoreException, IOException {
        this.setCrlSettings();
        this.directoryLocations = this.getListOfValues(PROP_DIRECTORY_LOCATIONS);
        this.directoryEncoding = this.getEnumValue(PROP_DIRECTORY_ENCODING, CertificateUtils.Encoding.class);
        this.caConnectionTimeout = this.getIntValue(PROP_DIRECTORY_CONNECTION_TIMEOUT);
        this.caDiskCache = this.getFileValueAsString(PROP_DIRECTORY_CACHE_PATH, true);
        ValidatorParamsExt params = this.getValidatorParamsExt();
        return new DirectoryCertChainValidator(this.directoryLocations, this.directoryEncoding, this.storeUpdateInterval * 1000L, this.caConnectionTimeout * 1000, this.caDiskCache, params);
    }

    private OpensslCertChainValidator getOpensslValidator() throws ConfigurationException {
        this.nsMode = this.getEnumValue(PROP_OPENSSL_NS_MODE, NamespaceCheckingMode.class);
        this.opensslDir = this.getFileValueAsString(PROP_OPENSSL_DIR, true);
        RevocationParameters.RevocationCheckingOrder order = this.getEnumValue(PROP_REVOCATION_ORDER, RevocationParameters.RevocationCheckingOrder.class);
        boolean useAll = this.getBooleanValue(PROP_REVOCATION_USE_ALL);
        RevocationParameters revocationSettings = new RevocationParameters(this.crlMode, this.getOCSPParameters(), useAll, order);
        ValidatorParams params = new ValidatorParams(revocationSettings, this.proxySupport, this.initialListeners);
        return new OpensslCertChainValidator(this.opensslDir, this.nsMode, this.storeUpdateInterval * 1000L, params);
    }

    private KeystoreCertChainValidator getKeystoreValidator() throws ConfigurationException, KeyStoreException, IOException {
        this.setCrlSettings();
        this.ksPath = this.getValue(PROP_KS_PATH);
        if (this.ksPath == null) {
            throw new ConfigurationException("Keystore path must be set, property: " + this.prefix + PROP_KS_PATH);
        }
        File ks = new File(this.ksPath);
        if (!(ks.exists() && ks.canRead() && ks.isFile())) {
            throw new ConfigurationException("Keystore specified in the property " + this.prefix + PROP_KS_PATH + " must be an EXISTING, READABLE file: " + this.ksPath);
        }
        boolean preferCallback = this.passwordCallback != null && this.passwordCallback.ignoreProperties();
        char[] ksPassword = null;
        if (!preferCallback) {
            String pass = this.getValue(PROP_KS_PASSWORD);
            char[] cArray = ksPassword = pass == null ? null : pass.toCharArray();
        }
        if (ksPassword == null && this.passwordCallback != null) {
            ksPassword = this.passwordCallback.getPassword("truststore", this.ksPath);
        }
        if (ksPassword == null) {
            throw new ConfigurationException("Keystore password must be set, property: " + this.prefix + PROP_KS_PASSWORD);
        }
        this.ksType = this.getValue(PROP_KS_TYPE);
        if (this.ksType == null) {
            this.autodetectKeystoreType(ksPassword);
        }
        ValidatorParamsExt params = this.getValidatorParamsExt();
        return new KeystoreCertChainValidator(this.ksPath, ksPassword, this.ksType, this.storeUpdateInterval * 1000L, params);
    }

    private void setCrlSettings() throws ConfigurationException {
        this.crlUpdateInterval = this.getLongValue(PROP_CRL_UPDATE);
        this.crlConnectionTimeout = this.getIntValue(PROP_CRL_CONNECTION_TIMEOUT);
        this.crlDiskCache = this.getFileValueAsString(PROP_CRL_CACHE_PATH, true);
        this.crlLocations = this.getListOfValues(PROP_CRL_LOCATIONS);
    }

    private ValidatorParamsExt getValidatorParamsExt() {
        CRLParameters crlParameters = new CRLParameters(this.crlLocations, this.crlUpdateInterval * 1000L, this.crlConnectionTimeout, this.crlDiskCache);
        RevocationParameters.RevocationCheckingOrder order = this.getEnumValue(PROP_REVOCATION_ORDER, RevocationParameters.RevocationCheckingOrder.class);
        boolean useAll = this.getBooleanValue(PROP_REVOCATION_USE_ALL);
        RevocationParametersExt revParams = new RevocationParametersExt(this.crlMode, crlParameters, this.getOCSPParameters(), useAll, order);
        return new ValidatorParamsExt(revParams, this.proxySupport, this.initialListeners);
    }

    private OCSPParametes getOCSPParameters() {
        OCSPCheckingMode checkingMode = this.getEnumValue(PROP_OCSP_MODE, OCSPCheckingMode.class);
        int connectTimeout = this.getIntValue(PROP_OCSP_TIMEOUT);
        int cacheTtl = this.getIntValue(PROP_OCSP_CACHE_TTL);
        String diskCachePath = this.getFileValueAsString(PROP_OCSP_DISK_CACHE, true);
        List<String> localRespondersCfg = this.getListOfValues(PROP_OCSP_LOCAL_RESPONDERS);
        OCSPResponder[] localResponders = new OCSPResponder[localRespondersCfg.size()];
        int i = 0;
        while (i < localResponders.length) {
            String cfg = localRespondersCfg.get(i);
            cfg = cfg.trim();
            String[] arr = cfg.split("[ ]+");
            BufferedInputStream is = null;
            if (arr.length != 2) {
                throw new ConfigurationException("Local responder's number " + (i + 1) + " configuration is invalid, must be: " + "'<responderURL> <responderPemCertificatePath>'");
            }
            try {
                try {
                    is = new BufferedInputStream(new FileInputStream(arr[1]));
                    X509Certificate cert = CertificateUtils.loadCertificate(is, CertificateUtils.Encoding.PEM);
                    localResponders[i] = new OCSPResponder(new URL(arr[0]), cert);
                }
                catch (FileNotFoundException e) {
                    throw new ConfigurationException("Local responder's number " + (i + 1) + " certificate can not be loaded, file " + arr[1] + " not found.", e);
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("Local responder's URL " + arr[0] + " is malformed: " + e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new ConfigurationException("Local responder's number " + (i + 1) + " certificate can not be loaded: " + e.getMessage(), e);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ++i;
        }
        return new OCSPParametes(checkingMode, localResponders, connectTimeout, true, false, cacheTtl, diskCachePath);
    }

    private void autodetectKeystoreType(char[] ksPassword) throws ConfigurationException {
        try {
            this.ksType = KeystoreCredential.autodetectType(this.ksPath, ksPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationException("Truststore type is not set in the property " + this.prefix + PROP_KS_TYPE + " and its autodetection failed. Try to set it and also " + "review password and location - most probably those are wrong.");
        }
    }

    @Override
    public TruststoreProperties clone() {
        TruststoreProperties ret = new TruststoreProperties(this.properties, this.initialListeners, this.passwordCallback, this.prefix);
        super.cloneTo(ret);
        return ret;
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private final String[] UPDATEABLE_PROPS = new String[]{"updateInterval", "crlUpdateInterval", "directoryLocations.", "crlLocations."};

        private PropertyChangeListenerImpl() {
        }

        @Override
        public String[] getInterestingProperties() {
            return this.UPDATEABLE_PROPS;
        }

        @Override
        public void propertyChanged(String propertyKey) {
            TruststoreProperties.this.update(propertyKey);
        }
    }

    public static enum TruststoreType {
        keystore,
        openssl,
        directory;

    }
}

