/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.canl;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import eu.unicore.security.canl.LoggingX509TrustManager;
import eu.unicore.util.httpclient.NoAuthKeyManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class SSLContextCreator {
    public static SSLContext createSSLContext(X509Credential credential, X509CertChainValidator validator, String protocol, String loginfo, Logger log) throws NoSuchAlgorithmException, KeyManagementException {
        X509KeyManager km;
        if (credential != null) {
            km = credential.getKeyManager();
            if (log.isTraceEnabled()) {
                SSLContextCreator.debugKS(credential, loginfo, log);
            }
        } else {
            km = new NoAuthKeyManager();
            log.trace("Creating SSL context without client's certificate for " + loginfo);
        }
        X509TrustManager tm = SocketFactoryCreator.getSSLTrustManager(validator);
        tm = new LoggingX509TrustManager(tm, loginfo);
        if (log.isTraceEnabled()) {
            SSLContextCreator.debugTS(validator, loginfo, log);
        }
        SSLContext sslcontext = SSLContext.getInstance(protocol);
        sslcontext.init(new KeyManager[]{km}, new TrustManager[]{tm}, null);
        return sslcontext;
    }

    private static void debugTS(X509CertChainValidator validator, String loginfo, Logger log) {
        X509Certificate[] trustedCerts;
        X509Certificate[] x509CertificateArray = trustedCerts = validator.getTrustedIssuers();
        int n = trustedCerts.length;
        int n2 = 0;
        while (n2 < n) {
            X509Certificate cert = x509CertificateArray[n2];
            log.trace("Initially trusted certificates for " + loginfo + ":\n" + CertificateUtils.format(cert, FormatMode.FULL));
            ++n2;
        }
    }

    private static void debugKS(X509Credential c, String loginfo, Logger log) {
        Certificate[] certs = c.getCertificateChain();
        X509Certificate[] certs509 = CertificateUtils.convertToX509Chain(certs);
        log.trace("Client's certificate chain for " + loginfo + ": " + CertificateUtils.format(certs509, FormatMode.FULL));
    }
}

