/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security;

import eu.unicore.security.SecurityException;
import java.io.Serializable;
import java.util.Arrays;

public class Xlogin
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] logins;
    private String selectedLogin;
    private String[] groups;
    private String selectedGroup;
    private String[] selectedSupplementaryGroups;
    private boolean addDefaultGroups = true;

    public Xlogin(String[] logins) {
        this.logins = logins;
    }

    public Xlogin(String[] logins, String[] groups) {
        this.logins = logins;
        this.groups = groups;
    }

    public Xlogin() {
    }

    public void setSelectedLogin(String login) throws SecurityException {
        if (!this.isValid(login)) {
            throw new SecurityException("Requested login <" + login + "> is not available.");
        }
        this.selectedLogin = login;
    }

    public String getUserName() {
        if (this.logins == null) {
            return null;
        }
        return this.selectedLogin != null ? this.selectedLogin : this.logins[0];
    }

    public boolean isValid(String preferredLogin) {
        if (preferredLogin == null) {
            return true;
        }
        if (this.logins == null) {
            return false;
        }
        String[] stringArray = this.logins;
        int n = this.logins.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (preferredLogin.equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String[] getLogins() {
        return this.logins;
    }

    public String getEncoded() {
        return this.getEncodedInteranl(this.logins);
    }

    public String getEncodedGroups() {
        return this.getEncodedInteranl(this.groups);
    }

    private String getEncodedInteranl(String[] array) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        if (array != null) {
            String[] stringArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (i > 0) {
                    sb.append(":");
                }
                sb.append(s);
                ++i;
                ++n2;
            }
        }
        return sb.toString();
    }

    public boolean isMultiLogin() {
        return this.logins != null && this.logins.length > 1;
    }

    public void setSelectedGroup(String group) throws SecurityException {
        if (!this.isValidGroup(group)) {
            throw new SecurityException("Requested group <" + group + "> is not available.");
        }
        this.selectedGroup = group;
    }

    public boolean isGroupSelected() {
        return this.selectedGroup != null;
    }

    public void setSelectedSupplementaryGroups(String[] groups) throws SecurityException {
        int i = 0;
        while (i < groups.length) {
            if (!this.isValidGroup(groups[i])) {
                throw new SecurityException("Requested group <" + groups[i] + "> is not available.");
            }
            ++i;
        }
        this.selectedSupplementaryGroups = Arrays.copyOf(groups, groups.length);
    }

    public boolean isValidGroup(String preferredGroup) {
        if (preferredGroup == null) {
            return true;
        }
        if (this.groups == null) {
            return false;
        }
        String[] stringArray = this.groups;
        int n = this.groups.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (preferredGroup.equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String[] getGroups() {
        return this.groups == null ? null : (String[])this.groups.clone();
    }

    public String getGroup() {
        if (this.selectedGroup != null) {
            return this.selectedGroup;
        }
        if (this.groups == null || this.groups.length == 0) {
            return null;
        }
        return this.groups[0];
    }

    public String[] getSelectedSupplementaryGroups() {
        return this.selectedSupplementaryGroups == null ? null : (String[])this.selectedSupplementaryGroups.clone();
    }

    public String getEncodedSelectedSupplementaryGroups() {
        return this.getEncodedInteranl(this.selectedSupplementaryGroups);
    }

    public String toString() {
        StringBuilder cInfo = new StringBuilder(256);
        cInfo.append("uid: [");
        cInfo.append(this.getEncoded());
        if (this.isMultiLogin()) {
            cInfo.append(", active=");
            cInfo.append(this.getUserName());
        }
        cInfo.append("], gids: [");
        if (this.groups != null && this.groups.length > 0) {
            cInfo.append(this.getEncodedGroups());
            if (this.groups.length > 1) {
                cInfo.append(", active=");
                cInfo.append(this.getGroup());
            }
            if (this.selectedSupplementaryGroups != null && this.selectedSupplementaryGroups.length > 0) {
                cInfo.append(", selectedSupplementaryGids=");
                cInfo.append(this.getEncodedSelectedSupplementaryGroups());
            }
            cInfo.append(", ");
        }
        cInfo.append("addingOSgroups: ");
        cInfo.append(this.isAddDefaultGroups());
        cInfo.append("]");
        return cInfo.toString();
    }

    public void setAddDefaultGroups(boolean addDefaultGroups) {
        this.addDefaultGroups = addDefaultGroups;
    }

    public boolean isAddDefaultGroups() {
        return this.addDefaultGroups;
    }
}

