/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security;

import java.io.Serializable;

public class XACMLAttribute
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String value;
    private Type type;

    public XACMLAttribute(String name, String value, Type type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XACMLAttribute other = (XACMLAttribute)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.name);
        sb.append(": ");
        sb.append(this.value);
        sb.append(" [");
        sb.append((Object)this.type);
        sb.append("]");
        return sb.toString();
    }

    public static enum Name {
        XACML_SUBJECT_ID_ATTR("urn:oasis:names:tc:xacml:1.0:subject:subject-id"),
        XACML_RESOURCE_ID_ATTR("urn:oasis:names:tc:xacml:1.0:resource:resource-id"),
        XACML_ACTION_ID_ATTR("urn:oasis:names:tc:xacml:1.0:action:action-id");

        private String name;

        private Name(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Type {
        STRING("http://www.w3.org/2001/XMLSchema#string"),
        BOOL("http://www.w3.org/2001/XMLSchema#boolean"),
        INTEGER("http://www.w3.org/2001/XMLSchema#integer"),
        DOUBLE("http://www.w3.org/2001/XMLSchema#double"),
        TIME("http://www.w3.org/2001/XMLSchema#time"),
        DATETIME("http://www.w3.org/2001/XMLSchema#dateTime"),
        ANYURI("http://www.w3.org/2001/XMLSchema#anyURI"),
        HEXBINARY("http://www.w3.org/2001/XMLSchema#hexBinary"),
        BASE64BINARY("http://www.w3.org/2001/XMLSchema#base64Binary"),
        X500NAME("urn:oasis:names:tc:xacml:1.0:data-type:x500Name"),
        RFC822NAME("urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name"),
        IP("urn:oasis:names:tc:xacml:2.0:data-type:ipAddress"),
        DNS("urn:oasis:names:tc:xacml:2.0:data-type:dnsName");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

