/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security;

import eu.unicore.security.XACMLAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class SubjectAttributesHolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, List<XACMLAttribute>> xacmlAttributes;
    private Map<String, String[]> defaultIncarnationAttributes;
    private Map<String, String[]> validIncarnationAttributes;
    private Map<String, String[]> preferredVoIncarnationAttributes = new HashMap<String, String[]>();
    private String selectedVo;
    private String[] preferredVos;

    public SubjectAttributesHolder() {
        this(new String[0]);
    }

    public SubjectAttributesHolder(String[] preferredVos) {
        this.xacmlAttributes = new HashMap<String, List<XACMLAttribute>>();
        this.defaultIncarnationAttributes = new HashMap<String, String[]>();
        this.validIncarnationAttributes = new HashMap<String, String[]>();
        this.preferredVos = preferredVos;
    }

    public SubjectAttributesHolder(Map<String, String[]> incarnationAttributes) {
        this(null, incarnationAttributes, incarnationAttributes);
    }

    public SubjectAttributesHolder(Map<String, String[]> defaultIncarnationAttributes, Map<String, String[]> validIncarnationAttributes) {
        this(null, defaultIncarnationAttributes, validIncarnationAttributes);
    }

    public SubjectAttributesHolder(List<XACMLAttribute> xacmlAttributes, Map<String, String[]> defaultIncarnationAttributes, Map<String, String[]> validIncarnationAttributes) {
        this.setXacmlAttributes(xacmlAttributes);
        this.setAllIncarnationAttributes(defaultIncarnationAttributes, validIncarnationAttributes);
    }

    public void addAllOverwritting(SubjectAttributesHolder from) {
        this.addAllCommon(from);
        if (from.getValidIncarnationAttributes() != null) {
            this.validIncarnationAttributes.putAll(from.getValidIncarnationAttributes());
        }
        if (from.getXacmlAttributes() != null) {
            for (XACMLAttribute xacmlAttribute : from.getXacmlAttributes()) {
                this.xacmlAttributes.remove(xacmlAttribute.getName());
            }
            for (XACMLAttribute xacmlAttribute : from.getXacmlAttributes()) {
                this.addToXACMLList(xacmlAttribute);
            }
        }
    }

    public void addAllMerging(SubjectAttributesHolder from) {
        this.addAllCommon(from);
        if (from.getValidIncarnationAttributes() != null) {
            for (Map.Entry entry : from.getValidIncarnationAttributes().entrySet()) {
                String key = (String)entry.getKey();
                String[] existing = this.validIncarnationAttributes.get(key);
                String[] newAttr = (String[])entry.getValue();
                if (existing != null) {
                    LinkedHashSet<String> result = new LinkedHashSet<String>();
                    String[] stringArray = existing;
                    int n = existing.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String existingA = stringArray[n2];
                        result.add(existingA);
                        ++n2;
                    }
                    stringArray = newAttr;
                    n = newAttr.length;
                    n2 = 0;
                    while (n2 < n) {
                        String newA = stringArray[n2];
                        result.add(newA);
                        ++n2;
                    }
                    this.validIncarnationAttributes.put(key, result.toArray(new String[result.size()]));
                    continue;
                }
                this.validIncarnationAttributes.put(key, newAttr);
            }
        }
        if (from.getXacmlAttributes() != null) {
            for (XACMLAttribute xACMLAttribute : from.getXacmlAttributes()) {
                this.addToXACMLList(xACMLAttribute);
            }
        }
    }

    private void addAllCommon(SubjectAttributesHolder from) {
        int newPref;
        if (from.getDefaultIncarnationAttributes() != null) {
            this.defaultIncarnationAttributes.putAll(from.getDefaultIncarnationAttributes());
        }
        if (from.getSelectedVo() != null && (newPref = this.getVoPreferrence(from.getSelectedVo())) >= 0 && (this.selectedVo == null || newPref < this.getVoPreferrence(this.selectedVo))) {
            this.selectedVo = from.getSelectedVo();
            this.preferredVoIncarnationAttributes.putAll(from.getPreferredVoIncarnationAttributes());
        }
    }

    private void addToXACMLList(XACMLAttribute a) {
        List<XACMLAttribute> current = this.xacmlAttributes.get(a.getName());
        if (current == null) {
            current = new ArrayList<XACMLAttribute>();
            this.xacmlAttributes.put(a.getName(), current);
        }
        if (!current.contains(a)) {
            current.add(a);
        }
    }

    public List<XACMLAttribute> getXacmlAttributes() {
        ArrayList<XACMLAttribute> ret = new ArrayList<XACMLAttribute>();
        Collection<List<XACMLAttribute>> vals = this.xacmlAttributes.values();
        for (List<XACMLAttribute> val : vals) {
            ret.addAll(val);
        }
        return ret;
    }

    public void setXacmlAttributes(List<XACMLAttribute> xacmlAttributes) {
        this.xacmlAttributes = new HashMap<String, List<XACMLAttribute>>();
        if (xacmlAttributes != null) {
            for (XACMLAttribute a : xacmlAttributes) {
                this.addToXACMLList(a);
            }
        }
    }

    public Map<String, String[]> getIncarnationAttributes() {
        if (this.validateVoIncarnationAttributes()) {
            HashMap<String, String[]> ret = new HashMap<String, String[]>();
            ret.putAll(this.getDefaultIncarnationAttributes());
            ret.putAll(this.getPreferredVoIncarnationAttributes());
            return ret;
        }
        return this.getDefaultIncarnationAttributes();
    }

    public Map<String, String[]> getDefaultIncarnationAttributes() {
        return this.defaultIncarnationAttributes;
    }

    public Map<String, String[]> getValidIncarnationAttributes() {
        return this.validIncarnationAttributes;
    }

    public Map<String, String[]> getPreferredVoIncarnationAttributes() {
        return this.preferredVoIncarnationAttributes;
    }

    public void setPreferredVoIncarnationAttributes(String exactVo, Map<String, String[]> preferredVoIncarnationAttributes) {
        if (exactVo == null) {
            throw new IllegalArgumentException("Preferred VO can not be null");
        }
        String[] stringArray = this.preferredVos;
        int n = this.preferredVos.length;
        int n2 = 0;
        while (n2 < n) {
            String vo = stringArray[n2];
            if (vo.equals(exactVo)) {
                this.selectedVo = exactVo;
                this.preferredVoIncarnationAttributes = preferredVoIncarnationAttributes;
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Selected VO must be one of the preferred VOs");
    }

    public int getVoPreferrence(String vo) {
        int i = 0;
        while (i < this.preferredVos.length) {
            if (this.preferredVos[i].equals(vo)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getSelectedVo() {
        return this.selectedVo;
    }

    public String[] getPreferredVos() {
        return this.preferredVos;
    }

    public void setPreferredVos(String[] preferredVos) {
        this.preferredVos = preferredVos;
    }

    public boolean validateVoIncarnationAttributes() {
        if (this.preferredVoIncarnationAttributes.size() == 0) {
            return false;
        }
        try {
            SubjectAttributesHolder.testSubset(this.preferredVoIncarnationAttributes, this.validIncarnationAttributes);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void setAllIncarnationAttributes(Map<String, String[]> defaultIncarnationAttributes, Map<String, String[]> validIncarnationAttributes) {
        if (defaultIncarnationAttributes == null || validIncarnationAttributes == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        SubjectAttributesHolder.testSubset(defaultIncarnationAttributes, validIncarnationAttributes);
        this.defaultIncarnationAttributes = new HashMap<String, String[]>();
        this.defaultIncarnationAttributes.putAll(defaultIncarnationAttributes);
        this.validIncarnationAttributes = new HashMap<String, String[]>();
        this.validIncarnationAttributes.putAll(validIncarnationAttributes);
    }

    private static void testSubset(Map<String, String[]> attributes, Map<String, String[]> validAttributes) {
        for (Map.Entry<String, String[]> defA : attributes.entrySet()) {
            if (validAttributes.containsKey(defA.getKey())) {
                String[] defaultVals;
                String[] validVals = validAttributes.get(defA.getKey());
                String[] stringArray = defaultVals = defA.getValue();
                int n = defaultVals.length;
                int n2 = 0;
                while (n2 < n) {
                    String defaultVal = stringArray[n2];
                    boolean found = false;
                    String[] stringArray2 = validVals;
                    int n3 = validVals.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String validVal = stringArray2[n4];
                        if (validVal.equals(defaultVal)) {
                            found = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!found) {
                        throw new IllegalArgumentException("The default incarnation attribute >" + defA.getKey() + "< value >" + defaultVal + "< is not present among valid incarnation attributes.");
                    }
                    ++n2;
                }
                continue;
            }
            throw new IllegalArgumentException("The default incarnation attribute " + defA.getKey() + " is not present among valid incarnation attributes.");
        }
    }

    public boolean isPresent() {
        if (this.defaultIncarnationAttributes.size() > 0) {
            return true;
        }
        return this.xacmlAttributes.size() > 0;
    }

    private static void outputAttrsMap(StringBuilder sb, Map<String, String[]> attrs) {
        Iterator<Map.Entry<String, String[]>> valid = attrs.entrySet().iterator();
        while (valid.hasNext()) {
            Map.Entry<String, String[]> validE = valid.next();
            sb.append(validE.getKey());
            sb.append(": ");
            sb.append(Arrays.toString(validE.getValue()));
            if (!valid.hasNext()) continue;
            sb.append("; ");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        boolean needEnter = false;
        if (this.validIncarnationAttributes.size() != 0) {
            sb.append("Valid attribute values: ");
            SubjectAttributesHolder.outputAttrsMap(sb, this.validIncarnationAttributes);
            needEnter = true;
        }
        if (this.defaultIncarnationAttributes.size() != 0) {
            if (needEnter) {
                sb.append("\n");
            }
            sb.append("Default attribute values: ");
            SubjectAttributesHolder.outputAttrsMap(sb, this.defaultIncarnationAttributes);
            needEnter = true;
        }
        if (this.preferredVoIncarnationAttributes.size() != 0 && this.selectedVo != null) {
            if (needEnter) {
                sb.append("\n");
            }
            sb.append("Selected VO: ").append(this.selectedVo).append(", its attribute values: ");
            SubjectAttributesHolder.outputAttrsMap(sb, this.preferredVoIncarnationAttributes);
            needEnter = true;
        }
        if (this.xacmlAttributes.size() > 0) {
            if (needEnter) {
                sb.append("\n");
            }
            sb.append("XACML authorization attributes: ");
            for (Map.Entry<String, List<XACMLAttribute>> validE : this.xacmlAttributes.entrySet()) {
                sb.append(validE.getValue());
            }
        }
        return sb.toString();
    }
}

