/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security;

import eu.unicore.security.SecurityException;
import java.io.Serializable;

public class Queue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String selectedQueue;
    private String[] validQueues;

    public Queue(String[] validQueues) {
        this.validQueues = validQueues;
        if (validQueues == null) {
            this.validQueues = new String[0];
        }
    }

    public Queue() {
        this.validQueues = new String[0];
    }

    public String getSelectedQueue() {
        if (this.selectedQueue == null && this.validQueues.length > 0) {
            return this.validQueues[0];
        }
        return this.selectedQueue;
    }

    public void setSelectedQueue(String selectedQueue) {
        String[] stringArray = this.validQueues;
        int n = this.validQueues.length;
        int n2 = 0;
        while (n2 < n) {
            String valid = stringArray[n2];
            if (valid.equals(selectedQueue)) {
                this.selectedQueue = selectedQueue;
                return;
            }
            ++n2;
        }
        throw new SecurityException("Requested queue <" + selectedQueue + "> is not available.");
    }

    public String[] getValidQueues() {
        return this.validQueues;
    }

    public void setValidQueues(String[] validQueues) {
        this.validQueues = validQueues;
    }

    public boolean isSelectedQueueSet() {
        return this.selectedQueue != null;
    }

    public String toString() {
        if (this.getValidQueues().length == 0) {
            return "";
        }
        StringBuilder cInfo = new StringBuilder();
        cInfo.append("[");
        int i = 0;
        while (i < this.getValidQueues().length - 1) {
            cInfo.append(this.getValidQueues()[i]);
            cInfo.append(":");
            ++i;
        }
        cInfo.append(this.getValidQueues()[this.getValidQueues().length - 1]);
        if (this.getValidQueues().length > 1) {
            cInfo.append(", selected=");
            cInfo.append(this.getSelectedQueue());
        }
        cInfo.append("]");
        return cInfo.toString();
    }
}

