/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.elements.NameIDPolicy;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.exceptions.SAMLRequestException;
import eu.unicore.samly2.proto.AbstractRequest;
import eu.unicore.security.dsig.DSigException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingRequestDocument;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingRequestType;
import xmlbeans.org.oasis.saml2.protocol.NameIDPolicyType;

public class NameIDMappingRequest
extends AbstractRequest {
    private NameIDMappingRequestDocument xbdoc;
    private NameIDMappingRequestType mapXml;

    public NameIDMappingRequest(NameIDMappingRequestDocument src) throws SAMLProtocolException {
        super(src.getNameIDMappingRequest());
        this.xbdoc = src;
        this.mapXml = this.xbdoc.getNameIDMappingRequest();
        this.parse();
    }

    public NameIDMappingRequest(NameID issuer, NameID toMap, NameIDPolicy policy) {
        this.xbdoc = NameIDMappingRequestDocument.Factory.newInstance();
        this.mapXml = this.xbdoc.addNewNameIDMappingRequest();
        this.init(this.mapXml, issuer);
        this.mapXml.setNameIDPolicy(policy.getXBean());
        this.mapXml.setNameID(toMap.getXBean());
    }

    @Override
    public void parse() throws SAMLProtocolException {
        super.parse();
        NameIDPolicyType policy = this.mapXml.getNameIDPolicy();
        if (policy == null) {
            throw new SAMLRequestException(null, "NameIDPolicy can't be null");
        }
        if (policy.getSPNameQualifier() != null) {
            throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", "Specified SPNameQualifier is unknown");
        }
        String requestedFormat = policy.getFormat();
        if (requestedFormat == null) {
            requestedFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        }
        if (requestedFormat.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted")) {
            throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", "Encryption of names is unsupported.");
        }
        NameIDType originalName = this.mapXml.getNameID();
        if (originalName == null) {
            if (this.mapXml.getBaseID() != null || this.mapXml.getEncryptedID() != null) {
                throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipial", "Only NameID element is supported as a way to specify name to be mapped");
            }
            throw new SAMLRequestException(null, "No nameID to map is specified");
        }
    }

    public NameIDPolicy getPolicy() {
        return new NameIDPolicy(this.mapXml.getNameIDPolicy());
    }

    public NameID getNameToMap() {
        return new NameID(this.mapXml.getNameID());
    }

    @Override
    public boolean isCorrectlySigned(PublicKey key) throws DSigException {
        return this.isCorrectlySigned(key, (Document)this.xbdoc.getDomNode());
    }

    @Override
    public void sign(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        Document doc = this.signInt(pk, cert);
        try {
            this.xbdoc = NameIDMappingRequestDocument.Factory.parse(doc);
            this.xmlReq = this.xbdoc.getNameIDMappingRequest();
            this.mapXml = this.xbdoc.getNameIDMappingRequest();
        }
        catch (XmlException e) {
            throw new DSigException("Parsing signed document failed", e);
        }
    }

    @Override
    public NameIDMappingRequestDocument getDoc() {
        return this.xbdoc;
    }
}

