/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.samly2.elements.Subject;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.proto.AbstractSubjectQuery;
import eu.unicore.security.dsig.DSigException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.org.oasis.saml2.protocol.AttributeQueryDocument;
import xmlbeans.org.oasis.saml2.protocol.AttributeQueryType;

public class AttributeQuery
extends AbstractSubjectQuery {
    private AttributeQueryDocument xbdoc;
    private AttributeQueryType attrXml;

    public AttributeQuery(AttributeQueryDocument src) throws SAMLProtocolException {
        super(src.getAttributeQuery());
        this.xbdoc = src;
        this.attrXml = src.getAttributeQuery();
        this.parse();
    }

    public AttributeQuery(NameID issuer, Subject subject) {
        this.xbdoc = AttributeQueryDocument.Factory.newInstance();
        this.attrXml = this.xbdoc.addNewAttributeQuery();
        this.init(this.attrXml, issuer, subject);
    }

    public void setAttributes(SAMLAttribute[] attributes) {
        int i = 0;
        while (i < attributes.length) {
            this.attrXml.insertNewAttribute(i);
            this.attrXml.setAttributeArray(i, attributes[i].getXBean());
            ++i;
        }
    }

    public AttributeType[] getAttributes() {
        return this.attrXml.getAttributeArray();
    }

    @Override
    public AttributeQueryDocument getDoc() {
        return this.xbdoc;
    }

    @Override
    public void sign(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        Document doc = this.signInt(pk, cert);
        try {
            this.xbdoc = AttributeQueryDocument.Factory.parse(doc);
            this.xmlReq = this.xbdoc.getAttributeQuery();
            this.attrXml = (AttributeQueryType)this.xmlReq;
        }
        catch (XmlException e) {
            throw new DSigException("Parsing signed document failed", e);
        }
    }

    @Override
    public boolean isCorrectlySigned(PublicKey key) throws DSigException {
        return this.isCorrectlySigned(key, (Document)this.xbdoc.getDomNode());
    }
}

