/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.job.jsdl;

import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.job.model.Export;
import eu.unicore.hila.job.model.Import;
import eu.unicore.hila.job.model.JobModel;
import eu.unicore.hila.job.model.StageIn;
import eu.unicore.hila.job.model.StageOut;
import eu.unicore.hila.job.spi.ModelToNative;
import java.util.Map;
import org.apache.xmlbeans.XmlCursor;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDescriptionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.ArgumentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.EnvironmentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.FileNameType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationType;

public class ModelToJsdl
implements ModelToNative {
    protected static final String FORMAT_JSDL = "jsdl";
    private JobModel jobModel = null;
    private long lastJsdlUpdate = 0L;
    private JobDefinitionDocument jsdl;

    public ModelToJsdl(JobModel _model) {
        this.jobModel = _model;
    }

    public JobDefinitionDocument getJSDL() throws HiLAException {
        if (this.jsdl == null || this.lastJsdlUpdate < this.jobModel.getLastModified()) {
            this.createJSDL();
        }
        return this.jsdl;
    }

    private void createJSDL() throws HiLAException {
        this.jsdl = JobDefinitionDocument.Factory.newInstance();
        JobDefinitionType jd = this.jsdl.addNewJobDefinition();
        JobDescriptionType jDescr = jd.addNewJobDescription();
        POSIXApplicationDocument posixAppD = POSIXApplicationDocument.Factory.newInstance();
        POSIXApplicationType posixApp = null;
        if (this.jobModel.getApplicationName() == null ^ this.jobModel.getExecutable() == null) {
            ApplicationType app = jDescr.addNewApplication();
            if (this.jobModel.getApplicationName() != null) {
                app.setApplicationName(this.jobModel.getApplicationName());
                if (this.jobModel.getApplicationVersion() != null) {
                    app.setApplicationVersion(this.jobModel.getApplicationVersion());
                }
            } else {
                posixApp = posixAppD.addNewPOSIXApplication();
                posixApp.addNewExecutable().setStringValue(this.jobModel.getExecutable());
            }
            if (this.jobModel.getArguments() != null) {
                for (String string : this.jobModel.getArguments()) {
                    if (posixApp == null) {
                        posixApp = posixAppD.addNewPOSIXApplication();
                    }
                    ArgumentType aType = posixApp.addNewArgument();
                    aType.setStringValue(string);
                }
            }
            if (this.jobModel.getStdin() != null) {
                FileNameType inName = FileNameType.Factory.newInstance();
                inName.setStringValue(this.jobModel.getStdin());
                if (posixApp == null) {
                    posixApp = posixAppD.addNewPOSIXApplication();
                }
                posixApp.setInput(inName);
            }
            if (this.jobModel.getStdout() != null) {
                FileNameType outName = FileNameType.Factory.newInstance();
                outName.setStringValue(this.jobModel.getStdout());
                if (posixApp == null) {
                    posixApp = posixAppD.addNewPOSIXApplication();
                }
                posixApp.setOutput(outName);
            }
            if (this.jobModel.getStderr() != null) {
                FileNameType errName = FileNameType.Factory.newInstance();
                errName.setStringValue(this.jobModel.getStderr());
                if (posixApp == null) {
                    posixApp = posixAppD.addNewPOSIXApplication();
                }
                posixApp.setError(errName);
            }
            if (this.jobModel.getEnvironment() != null) {
                for (Map.Entry entry : this.jobModel.getEnvironment().entrySet()) {
                    if (posixApp == null) {
                        posixApp = posixAppD.addNewPOSIXApplication();
                    }
                    EnvironmentType eType = posixApp.addNewEnvironment();
                    eType.setName((String)entry.getKey());
                    eType.setStringValue((String)entry.getValue());
                }
            }
            if (posixApp != null) {
                XmlCursor cursor = app.newCursor();
                cursor.toEndToken();
                posixApp.newCursor().copyXml(cursor);
            }
        } else {
            throw new HiLAException("Need exactly one application for execution.");
        }
        if (this.jobModel.getTaskName() != null) {
            jDescr.addNewJobIdentification().setJobName(this.jobModel.getTaskName());
        }
        if (this.jobModel.getImports() != null) {
            for (Import imprt : this.jobModel.getImports()) {
                DataStagingType dataStagingType = jDescr.addNewDataStaging();
                dataStagingType.addNewSource().setURI(imprt.getSource().toString());
                dataStagingType.setFileName(imprt.getTargetName());
            }
        }
        if (this.jobModel.getExports() != null) {
            for (Export export : this.jobModel.getExports()) {
                DataStagingType dataStagingType = jDescr.addNewDataStaging();
                dataStagingType.addNewTarget().setURI(export.getTargetFile().toString());
                dataStagingType.setFileName(export.getSourcePath());
            }
        }
        if (this.jobModel.getStageIns() != null) {
            for (StageIn stageIn : this.jobModel.getStageIns()) {
                DataStagingType dataStagingType = jDescr.addNewDataStaging();
                dataStagingType.addNewSource().setURI(stageIn.getSourceURI());
                dataStagingType.setFileName(stageIn.getFileName());
                dataStagingType.setFilesystemName(stageIn.getFileSystemName());
                dataStagingType.setDeleteOnTermination(stageIn.isDeleteOnTermination());
            }
        }
        if (this.jobModel.getStageOuts() != null) {
            for (StageOut stageOut : this.jobModel.getStageOuts()) {
                DataStagingType dataStagingType = jDescr.addNewDataStaging();
                dataStagingType.addNewTarget().setURI(stageOut.getTargetURI());
                dataStagingType.setFileName(stageOut.getFileName());
                dataStagingType.setFilesystemName(stageOut.getFileSystemName());
                dataStagingType.setDeleteOnTermination(stageOut.isDeleteOnTermination());
            }
        }
        if (this.jobModel.getResources() != null) {
            jDescr.setResources(this.jobModel.getResources());
        }
        this.lastJsdlUpdate = System.currentTimeMillis();
    }

    public Object getNative() throws HiLAException {
        return this.getJSDL();
    }

    public String getFormatName() {
        return FORMAT_JSDL;
    }
}

