/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.TransferControllerClient;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseThirdPartyTransfer;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.exceptions.HiLAResourceNotFoundException;
import eu.unicore.hila.grid.Progressable;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.grid.ThirdPartyTransfer;
import eu.unicore.hila.grid.unicore6.Unicore6File;
import eu.unicore.hila.grid.unicore6.Unicore6TransfersCollection;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;

@ResourceType(locationStructure={"unicore6:/sites/{site}/storages/{storage}/transfers/{transfer}", "unicore6:/{user}@sites/{site}/storages/{storage}/transfers/{transfer}", "unicore6:/sites/{site}/tasks/{task}/wd/transfers/{transfer}", "unicore6:/{user}@sites/{site}/tasks/{task}/wd/transfers/{transfer}", "unicore6:/storages/{storage}/transfers/{transfer}", "unicore6:/{user}@storages/{storage}/transfers/{transfer}"})
public class Unicore6TransferTask
extends BaseThirdPartyTransfer
implements ThirdPartyTransfer,
Callable<TaskStatus>,
Progressable {
    Unicore6File source;
    Unicore6File destination;
    StorageClient sourceStorageClient;
    private StorageClient destinationStorageClient;
    private TransferControllerClient tcc;
    private long maxBytes;
    private long currentBytes;

    public Unicore6TransferTask(Unicore6File _source, StorageClient _sourceStorageClient, Unicore6File _destination, StorageClient _destinationStorageClient) throws HiLAException {
        super(_source.getStorage().getLocation().getChildLocation("transfers").getChildLocation(UUID.randomUUID().toString()));
        this.source = _source;
        this.destination = _destination;
        this.sourceStorageClient = _sourceStorageClient;
        try {
            IClientConfiguration tdSecProp = _destinationStorageClient.getSecurityConfiguration().clone();
            tdSecProp.getETDSettings().setExtendTrustDelegation(true);
            tdSecProp.getETDSettings().setIssuerCertificateChain(tdSecProp.getCredential().getCertificateChain());
            this.destinationStorageClient = new StorageClient(_destinationStorageClient.getEPR(), tdSecProp);
        }
        catch (CloneNotSupportedException e) {
            throw new HiLAException("Unable to clone security properties.", (Throwable)e);
        }
        catch (Exception e) {
            throw new HiLAException("Unable to create storage client with trust delegation.");
        }
        this.setCurrentState(TaskStatus.NEW);
        HiLA.getExecutor().submit(this);
        Unicore6TransfersCollection tc = (Unicore6TransfersCollection)this.getParent();
        if (tc != null) {
            tc.addTask(this);
        }
    }

    public static synchronized Unicore6TransferTask locate(Location _location, Object ... _extraInformation) throws HiLAException {
        Unicore6TransfersCollection transfersCollection = (Unicore6TransfersCollection)_location.getParentLocation().locate(new Object[0]);
        List<Resource> transfers = transfersCollection.getChildren();
        for (Resource resource : transfers) {
            if (!resource.getLocation().equals((Object)_location)) continue;
            return (Unicore6TransferTask)resource;
        }
        throw new HiLAResourceNotFoundException("This transfer does not exist: " + _location);
    }

    @Override
    public TaskStatus call() throws Exception {
        this.setCurrentState(TaskStatus.PENDING);
        String ftProto = "BFT";
        String sourceEPR = ftProto + ":" + this.sourceStorageClient.getEPR().getAddress().getStringValue() + "#" + this.source.getPath();
        this.tcc = this.destinationStorageClient.fetchFile(sourceEPR, this.destination.getPath());
        this.setCurrentState(TaskStatus.RUNNING);
        this.getCurrent();
        this.getMax();
        while (!this.tcc.isComplete()) {
            Thread.sleep(2000L);
        }
        this.getCurrent();
        this.getMax();
        if (this.tcc.hasFailed()) {
            HiLAException e = new HiLAException("Remote transfer has failed.");
            this.setCurrentState(TaskStatus.FAILED, e);
            this.tcc.destroy();
            this.tcc = null;
            throw e;
        }
        this.setCurrentState(TaskStatus.SUCCESSFUL);
        if (this.tcc != null) {
            this.tcc.destroy();
            this.tcc = null;
        }
        return this.status();
    }

    public void abort() throws HiLAException {
        try {
            this.tcc.destroy();
            this.tcc = null;
        }
        catch (BaseFault e) {
            throw new HiLAException("Unable to abort transfer", (Throwable)e);
        }
        catch (ResourceUnavailableFault e) {
            throw new HiLAException("Unable to abort transfer", (Throwable)e);
        }
        catch (ResourceUnknownFault e) {
            throw new HiLAException("Unable to abort transfer", (Throwable)e);
        }
        catch (ResourceNotDestroyedFault e) {
            throw new HiLAException("Unable to abort transfer", (Throwable)e);
        }
        catch (ClientException e) {
            throw new HiLAException("Unable to abort transfer", (Throwable)e);
        }
    }

    public String getId() {
        return this.location.getName();
    }

    public List<Resource> getChildren() throws HiLAException {
        return Collections.emptyList();
    }

    @Override
    public String getUnit() throws HiLANotImplementedException {
        return "bytes";
    }

    @Override
    public synchronized long getMax() throws HiLAException {
        if (this.tcc != null) {
            this.maxBytes = this.tcc.getSize();
        }
        return this.maxBytes;
    }

    @Override
    public synchronized long getCurrent() {
        if (this.tcc != null) {
            this.currentBytes = this.tcc.getTransferredBytes();
        }
        return this.currentBytes;
    }
}

