/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.TargetSystemFactory;
import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Config;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.unicore6.GetServicesFromRegistry;
import eu.unicore.hila.grid.unicore6.GetSitesFromTSF;
import eu.unicore.hila.grid.unicore6.Unicore6Grid;
import eu.unicore.hila.grid.unicore6.Unicore6Properties;
import eu.unicore.hila.grid.unicore6.Unicore6SecurityProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

@ResourceType(locationStructure={"unicore6:/sites/?", "unicore6:/{user}@sites/?"})
public class Unicore6SitesCollection
extends BaseResource
implements Resource {
    private static final Logger log = Logger.getLogger(Unicore6SitesCollection.class);
    private static final Map<Location, Unicore6SitesCollection> sitesCollections = new HashMap<Location, Unicore6SitesCollection>();
    private static ScheduledExecutorService executor = HiLA.getDaemonExecutor();
    private List<Resource> sites;
    private Config config = null;
    private Object configLock = new Object();
    private SitesCollectionUpdater updater;
    private boolean initialized = false;
    private HiLAException lastError;

    private Unicore6SitesCollection(Location location) throws HiLAException {
        super(location);
        this.sites = new ArrayList<Resource>();
        this.updater = new SitesCollectionUpdater(this);
        String sUpdateInterval = ((Unicore6Grid)this.getParent()).getProperties().getProperty("hila.unicore6.refresh", "60000");
        long updateInterval = Long.parseLong(sUpdateInterval);
        executor.scheduleAtFixedRate(this.updater, 0L, updateInterval, TimeUnit.MILLISECONDS);
    }

    public static Unicore6SitesCollection locate(Location _location, Object ... _extraInformation) throws HiLAException {
        if (sitesCollections.containsKey(_location)) {
            return sitesCollections.get(_location);
        }
        Unicore6SitesCollection sitesCollection = new Unicore6SitesCollection(_location);
        sitesCollections.put(_location, sitesCollection);
        return sitesCollection;
    }

    public synchronized List<Resource> getChildren() throws HiLAException {
        if (!this.initialized && this.lastError != null) {
            throw new HiLAException("An error occured during site update", (Throwable)this.lastError);
        }
        if (!this.initialized) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.sites;
    }

    protected synchronized void setSites(List<Site> _sites) {
        this.sites.clear();
        this.sites.addAll(_sites);
        this.initialized = true;
        this.clearError();
        ((Object)((Object)this)).notify();
    }

    protected synchronized void setError(HiLAException _exception) {
        this.lastError = _exception;
    }

    private synchronized void clearError() {
        this.lastError = null;
    }

    private class SitesCollectionUpdater
    implements Runnable {
        private Unicore6SitesCollection sitesCollection;
        private List<String> registryURLs;
        private Unicore6Properties props;

        public SitesCollectionUpdater(Unicore6SitesCollection _sitesCollection) throws HiLAException {
            this.sitesCollection = _sitesCollection;
            Unicore6Grid grid = (Unicore6Grid)this.sitesCollection.getParent();
            this.props = grid.getProperties();
            this.registryURLs = this.props.getRegistryUrls();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Unicore6SecurityProperties secProps;
            long timeoutMillis = Long.parseLong(this.props.getProperty("hila.unicore6.timeout", "5000"));
            if (Unicore6SitesCollection.this.config == null) {
                Object object = Unicore6SitesCollection.this.configLock;
                synchronized (object) {
                    if (Unicore6SitesCollection.this.config == null) {
                        Constructor<?> constructor;
                        Class<?> configClass;
                        String configProviderClass = this.props.getConfigImplementation();
                        try {
                            configClass = Class.forName(configProviderClass);
                        }
                        catch (ClassNotFoundException e) {
                            Unicore6SitesCollection.this.setError(new HiLAException("hila.unicore6.config references unknown class" + configProviderClass, (Throwable)e));
                            return;
                        }
                        catch (ClassCastException e) {
                            Unicore6SitesCollection.this.setError(new HiLAException(configProviderClass + " is not a subclass of " + Config.class.getName()));
                            return;
                        }
                        try {
                            constructor = configClass.getConstructor(Unicore6Properties.class);
                        }
                        catch (SecurityException e) {
                            Unicore6SitesCollection.this.setError(new HiLAException(e.getMessage(), (Throwable)e));
                            return;
                        }
                        catch (NoSuchMethodException e) {
                            Unicore6SitesCollection.this.setError(new HiLAException("Config implementation referenced in hila.unicore6.config does not provide the correct constructor", (Throwable)e));
                            return;
                        }
                        try {
                            Unicore6SitesCollection.this.config = (Config)constructor.newInstance(this.props);
                        }
                        catch (IllegalArgumentException e) {
                            Unicore6SitesCollection.this.setError(new HiLAException(e.getMessage(), (Throwable)e));
                            return;
                        }
                        catch (InstantiationException e) {
                            Unicore6SitesCollection.this.setError(new HiLAException(e.getMessage(), (Throwable)e));
                            return;
                        }
                        catch (IllegalAccessException e) {
                            Unicore6SitesCollection.this.setError(new HiLAException(e.getMessage(), (Throwable)e));
                            return;
                        }
                        catch (InvocationTargetException e) {
                            Unicore6SitesCollection.this.setError(new HiLAException(e.getMessage(), (Throwable)e));
                            return;
                        }
                    }
                }
            }
            try {
                secProps = (Unicore6SecurityProperties)Unicore6SitesCollection.this.config.getIdForLocation(Unicore6SitesCollection.this.location);
            }
            catch (HiLAException e1) {
                Unicore6SitesCollection.this.setError(e1);
                return;
            }
            if (secProps != null) {
                secProps = secProps.clone();
            }
            ArrayList<Site> sites = new ArrayList<Site>();
            ArrayList<Future<List<EndpointReferenceType>>> tsfFutures = new ArrayList<Future<List<EndpointReferenceType>>>();
            for (String registryURL : this.registryURLs) {
                GetServicesFromRegistry getTSFs = new GetServicesFromRegistry(registryURL, secProps, TargetSystemFactory.TSF_PORT);
                tsfFutures.add(executor.submit(getTSFs));
            }
            long tsfDeadline = System.currentTimeMillis() + timeoutMillis;
            for (Future future : tsfFutures) {
                try {
                    ArrayList<Future<List<Site>>> siteFutures = new ArrayList<Future<List<Site>>>();
                    List tsfEprs = (List)future.get(tsfDeadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    for (EndpointReferenceType endpointReferenceType : tsfEprs) {
                        GetSitesFromTSF getSites = new GetSitesFromTSF(endpointReferenceType, secProps, Unicore6SitesCollection.this.location, this.props.getSeparateTSSs());
                        siteFutures.add(executor.submit(getSites));
                    }
                    long siteDeadline = System.currentTimeMillis() + timeoutMillis;
                    for (Future future2 : siteFutures) {
                        try {
                            List tsfSites = (List)future2.get(siteDeadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                            sites.addAll(tsfSites);
                        }
                        catch (InterruptedException e) {
                            log.warn("Interrupted while waiting for list of sites.", e);
                        }
                        catch (ExecutionException e) {
                            log.warn("Error retrieving target systems.", e);
                        }
                        catch (TimeoutException e) {
                            log.warn("Retrieval of target systems timed out.", e);
                        }
                    }
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while waiting for list of TargetSystemFactory.", e);
                }
                catch (ExecutionException e) {
                    log.warn("Error retrieving target system factories.", e);
                }
                catch (TimeoutException e) {
                    log.warn("Retrieval of target system factories timed out.", e);
                }
            }
            Unicore6SitesCollection.this.setSites(sites);
        }
    }
}

