/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.ReservationClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import eu.unicore.hila.Location;
import eu.unicore.hila.Metadata;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseSite;
import eu.unicore.hila.exceptions.HiLACannotContactSiteException;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.exceptions.HiLANotSupportedException;
import eu.unicore.hila.exceptions.HiLAResourceAlreadyExistsException;
import eu.unicore.hila.exceptions.HiLAResourceNotFoundException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.Reservation;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.Storage;
import eu.unicore.hila.grid.resources.ResourceDescription;
import eu.unicore.hila.grid.unicore6.Unicore6File;
import eu.unicore.hila.grid.unicore6.Unicore6Grid;
import eu.unicore.hila.grid.unicore6.Unicore6Job;
import eu.unicore.hila.grid.unicore6.Unicore6Reservation;
import eu.unicore.hila.grid.unicore6.Unicore6ReservationsCollection;
import eu.unicore.hila.grid.unicore6.Unicore6SecurityProperties;
import eu.unicore.hila.grid.unicore6.Unicore6SitesCollection;
import eu.unicore.hila.job.model.JobModel;
import eu.unicore.hila.job.model.MappingFactory;
import eu.unicore.hila.job.spi.MappingFactorySpi;
import eu.unicore.hila.job.spi.ModelToNative;
import eu.unicore.hila.job.spi.NoSuchMappingException;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.SourceTargetType;
import org.unigrids.x2006.x04.services.sms.StoragePropertiesDocument;
import org.unigrids.x2006.x04.services.tss.ApplicationResourceType;
import org.unigrids.x2006.x04.services.tss.SubmitDocument;
import org.unigrids.x2006.x04.services.tss.TargetSystemPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

@ResourceType(locationStructure={"unicore6:/sites/{siteName}/?", "unicore6:/{user}@sites/{siteName}/?"})
public class Unicore6Site
extends BaseSite
implements Site {
    private static final String MSG_SITE_UNAVAILABLE = "Site is unavailable.";
    private static final Logger log = Logger.getLogger(Unicore6Site.class);
    private static final Cache sitesCache;
    private List<TSSClient> tssClients;
    private final Metadata metadata;
    private Unicore6ReservationsCollection reservationsCollection;
    private TSFClient tsfClient;

    private Unicore6Site(Location _location, Object ... _extraInformation) throws HiLAException {
        super(_location);
        for (Object object : _extraInformation) {
            if (object instanceof List && ((List)object).get(0) instanceof TSSClient) {
                this.tssClients = (List)object;
                continue;
            }
            if (!(object instanceof TSFClient)) continue;
            this.tsfClient = (TSFClient)object;
        }
        this.metadata = new Metadata();
        if (this.tssClients == null || this.tssClients.size() == 0) {
            throw new HiLACannotContactSiteException("Missing TSS for target system.");
        }
    }

    public static Unicore6Site locate(Location _location, Object ... extraInformation) throws HiLAException {
        Unicore6Site site;
        Element cacheElement = sitesCache.get(_location);
        if (cacheElement != null) {
            if (log.isDebugEnabled()) {
                log.debug("Found cache entry for " + _location);
            }
            if ((site = (Unicore6Site)((Object)cacheElement.getObjectValue())).ok()) {
                return site;
            }
            sitesCache.removeElement(cacheElement);
        }
        if (log.isDebugEnabled()) {
            log.debug("Cache for " + _location + " was invalid.");
        }
        if (extraInformation.length > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Creating new Site object for " + _location);
                if (log.isTraceEnabled()) {
                    for (Object object : extraInformation) {
                        log.trace("Using extraInformation " + object);
                    }
                }
            }
            site = new Unicore6Site(_location, extraInformation);
            sitesCache.put(new Element(_location, (Object)site));
            return site;
        }
        Location sitesLoc = Unicore6Site.findParentLocationOfType(Unicore6SitesCollection.class, (Location)_location, Unicore6Grid.class);
        for (Resource res : sitesLoc.locate(new Object[0]).getChildren()) {
            if (!res.getLocation().equals((Object)_location)) continue;
            return (Unicore6Site)res;
        }
        throw new HiLAResourceNotFoundException("Site " + _location + " cannot be found.");
    }

    @Override
    public synchronized List<Resource> getChildren() throws HiLALocationSyntaxException {
        List<Resource> children = super.getChildren();
        if (this.reservationsCollection == null) {
            this.reservationsCollection = new Unicore6ReservationsCollection(this.getLocation().getChildLocation("reservations"));
        }
        if (!children.contains((Object)this.reservationsCollection)) {
            children.add(this.reservationsCollection);
        }
        return children;
    }

    public Metadata getMetadata() throws HiLAException {
        this.updateMetadata();
        return this.metadata;
    }

    public Job getTask(String taskId) throws HiLAException {
        if (!this.ok()) {
            throw new HiLACannotContactSiteException(MSG_SITE_UNAVAILABLE);
        }
        String baseURL = this.tssClients.get(0).getEPR().getAddress().getStringValue().replaceAll("TargetSystemService.*", "");
        String jmAddress = baseURL + "JobManagement?res=" + taskId;
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        epr.addNewAddress().setStringValue(jmAddress);
        return this.createJobFromEPR(epr);
    }

    public Job submit(JobModel _jm) throws HiLAException {
        try {
            MappingFactorySpi mapping = MappingFactory.getMapping((String)"jsdl");
            ModelToNative m2n = mapping.createModelToNativeMapping(_jm);
            return this.submit((JobDefinitionDocument)m2n.getNative());
        }
        catch (NoSuchMappingException e) {
            throw new HiLAException("Unable to map job model to JSDL.", (Throwable)e);
        }
    }

    public Job submit(JobDefinitionDocument jdd) throws HiLAException {
        DataStagingType[] stagings;
        if (!this.ok()) {
            throw new HiLACannotContactSiteException(MSG_SITE_UNAVAILABLE);
        }
        for (DataStagingType staging : stagings = jdd.getJobDefinition().getJobDescription().getDataStagingArray()) {
            Location tgtLoc;
            SourceTargetType tgt;
            Location srcLoc;
            SourceTargetType src = staging.getSource();
            if (src != null && (srcLoc = new Location(src.getURI())).isLocationOfType(File.class)) {
                try {
                    Unicore6File f = (Unicore6File)srcLoc.locate(new Object[0]);
                    src.setURI("BFT:".concat(f.getStagingURI()));
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            if ((tgt = staging.getTarget()) == null || !(tgtLoc = new Location(tgt.getURI())).isLocationOfType(File.class)) continue;
            try {
                Unicore6File f = (Unicore6File)tgtLoc.locate(new Object[0]);
                tgt.setURI("BFT:".concat(f.getStagingURI()));
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        SubmitDocument sd = SubmitDocument.Factory.newInstance();
        sd.addNewSubmit().setJobDefinition(jdd.getJobDefinition());
        try {
            TSSClient existingTssClient = this.tssClients.get(0);
            Unicore6SecurityProperties sp = (Unicore6SecurityProperties)existingTssClient.getSecurityConfiguration().clone();
            sp.getETDSettings().setExtendTrustDelegation(true);
            TSSClient tssClient = new TSSClient(existingTssClient.getEPR(), sp);
            JobClient jobClient = tssClient.submit(sd);
            String taskId = Unicore6Site.epr2TaskId(jobClient.getEPR());
            Unicore6Job task = new Unicore6Job(this.location.getChildLocation("tasks").getChildLocation(taskId), jobClient);
            return task;
        }
        catch (Exception e) {
            throw new HiLAException("Error submitting job to target system.", (Throwable)e);
        }
    }

    @Override
    public List<Storage> getStorages() throws HiLAException {
        return this.getStorages1();
    }

    public List<Storage> getStorages1() throws HiLAException {
        ArrayList<Storage> storages = new ArrayList<Storage>();
        if (!this.ok()) {
            throw new HiLACannotContactSiteException(MSG_SITE_UNAVAILABLE);
        }
        List<EndpointReferenceType> storageReferences = this.tssClients.get(0).getStorages();
        for (EndpointReferenceType storageEPR : storageReferences) {
            try {
                IClientConfiguration storSecProp = this.tssClients.get(0).getSecurityConfiguration().clone();
                StorageClient sClient = new StorageClient(storageEPR.getAddress().getStringValue(), storageEPR, storSecProp);
                StoragePropertiesDocument spd = sClient.getResourcePropertiesDocument();
                String fileSystemName = spd.getStorageProperties().getFileSystem().getName();
                Location storageLocation = this.location.getChildLocation("storages").getChildLocation(fileSystemName);
                Storage storage = (Storage)storageLocation.locate(new Object[]{sClient});
                storages.add(storage);
            }
            catch (CloneNotSupportedException e) {
                throw new HiLAException("Unable to clone security properties.", (Throwable)e);
            }
            catch (Exception e) {
                throw new HiLAException("Unexpected exception while retrieving list of storages.", (Throwable)e);
            }
        }
        return storages;
    }

    public Storage getStorage(String storageName) throws HiLAException {
        List<Storage> storages = this.getStorages();
        for (Storage storage : storages) {
            if (!storage.getName().equals(storageName)) continue;
            return storage;
        }
        throw new HiLAException("Storage does not exist.");
    }

    public List<Job> getTasks() throws HiLAFactoryException, HiLACannotContactSiteException {
        ArrayList<Job> tasks = new ArrayList<Job>();
        if (!this.ok()) {
            throw new HiLACannotContactSiteException(MSG_SITE_UNAVAILABLE);
        }
        for (TSSClient tssClient : this.tssClients) {
            try {
                List<EndpointReferenceType> jobEprs = tssClient.getJobs();
                for (EndpointReferenceType jobEpr : jobEprs) {
                    tasks.add(this.createJobFromEPR(jobEpr));
                }
            }
            catch (Exception e) {
                log.error("Unable to list jobs.", e);
                this.ok();
            }
        }
        return tasks;
    }

    private Job createJobFromEPR(EndpointReferenceType jobEpr) throws HiLAException {
        if (!this.ok()) {
            throw new HiLACannotContactSiteException(MSG_SITE_UNAVAILABLE);
        }
        String resId = Unicore6Site.epr2TaskId(jobEpr);
        try {
            Location taskLocation = this.location.getChildLocation("tasks".concat("/").concat(resId));
            Job task = null;
            try {
                task = new Unicore6Job(taskLocation, new JobClient(jobEpr.getAddress().getStringValue(), jobEpr, this.tssClients.get(0).getSecurityConfiguration().clone()));
            }
            catch (HiLAResourceAlreadyExistsException e) {
                task = (Job)this.location.getChildLocation("tasks".concat("/").concat(resId)).locate(new Object[0]);
            }
            if (log.isDebugEnabled()) {
                log.debug("Located task ".concat(task.getLocation().toString()));
            }
            return task;
        }
        catch (CloneNotSupportedException e) {
            throw new HiLAException("Unable to clone security properties.", (Throwable)e);
        }
        catch (Exception e) {
            throw new HiLAException("Unexpected exception while retrieving list of tasks.", (Throwable)e);
        }
    }

    public static String epr2TaskId(EndpointReferenceType jobEpr) {
        String resId = jobEpr.getAddress().getStringValue().replaceFirst(".*\\?res=", "");
        if (log.isDebugEnabled()) {
            log.debug("resId = " + resId);
        }
        return resId;
    }

    private void updateMetadata() throws HiLAException {
        if (!this.ok()) {
            throw new HiLACannotContactSiteException(MSG_SITE_UNAVAILABLE);
        }
        try {
            TargetSystemPropertiesDocument tsp = this.tssClients.get(0).getResourcePropertiesDocument();
            ArrayList<ApplicationResourceType> applications = new ArrayList<ApplicationResourceType>();
            for (ApplicationResourceType application : tsp.getTargetSystemProperties().getApplicationResourceArray()) {
                applications.add(application);
            }
            this.metadata.setData("applications", applications);
            this.metadata.setData("resourceProperties", (Object)tsp);
        }
        catch (Exception e) {
            throw new HiLAException("Unable to retrieve TargetSystemProperties.", (Throwable)e);
        }
    }

    public Reservation reserve(ResourceDescription _rd, Calendar _startTime) throws HiLAException {
        if (!this.ok()) {
            throw new HiLACannotContactSiteException(MSG_SITE_UNAVAILABLE);
        }
        try {
            if (!this.tssClients.get(0).supportsReservation()) {
                throw new HiLANotSupportedException("Server does not support reservation.");
            }
        }
        catch (HiLANotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiLAException("Cannot determine whether server supports reservation.", (Throwable)e);
        }
        ReservationClient resClient = null;
        if (_rd.getActualDescription() instanceof ResourcesDocument) {
            try {
                resClient = this.tssClients.get(0).createReservationClient((ResourcesDocument)_rd.getActualDescription(), _startTime);
            }
            catch (Exception e) {
                throw new HiLAException("Unable to create reservation.", (Throwable)e);
            }
        } else {
            throw new HiLAException("Unknown resource description.");
        }
        if (resClient != null) {
            try {
                Location resLoc = this.getLocation().getChildLocation("reservations").getChildLocation(Unicore6Site.epr2TaskId(resClient.getEPR()));
                Unicore6Reservation u6res = (Unicore6Reservation)resLoc.locate(new Object[]{resClient});
                return u6res;
            }
            catch (Exception e) {
                throw new HiLAException("Cannot get reservation reference.", (Throwable)e);
            }
        }
        throw new HiLAException("Unable to create reservation.");
    }

    public List<Reservation> getReservations() throws HiLAException {
        ArrayList<Reservation> reservations = new ArrayList<Reservation>();
        if (!this.ok()) {
            throw new HiLACannotContactSiteException(MSG_SITE_UNAVAILABLE);
        }
        for (TSSClient tssClient : this.tssClients) {
            List<EndpointReferenceType> resEPRs = tssClient.getReservations();
            for (EndpointReferenceType resEPR : resEPRs) {
                ReservationClient resClient;
                try {
                    resClient = new ReservationClient(resEPR.getAddress().getStringValue(), resEPR, tssClient.getSecurityConfiguration().clone());
                }
                catch (CloneNotSupportedException e) {
                    throw new HiLAException("Something weird with security setup.", (Throwable)e);
                }
                catch (Exception e) {
                    throw new HiLAException("Cannot create reservation client.", (Throwable)e);
                }
                Location resLoc = this.getLocation().getChildLocation("reservations").getChildLocation(Unicore6Site.epr2TaskId(resEPR));
                reservations.add((Reservation)resLoc.locate(new Object[]{resClient}));
            }
        }
        return reservations;
    }

    public Reservation getReservation(String _name) throws HiLAException {
        List<Reservation> reservations = this.getReservations();
        for (Reservation reservation : reservations) {
            if (!reservation.getName().equals(_name)) continue;
            return reservation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ok() {
        ArrayList<TSSClient> removeList = new ArrayList<TSSClient>();
        for (TSSClient tssClient : this.tssClients) {
            try {
                if (!tssClient.checkConnection()) continue;
                boolean bl = true;
                return bl;
            }
            catch (ClientException e) {}
            continue;
            finally {
                removeList.add(tssClient);
            }
        }
        this.tssClients.removeAll(removeList);
        try {
            this.tssClients.add(this.tsfClient.createTSS());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        CacheManager manager = CacheManager.getInstance();
        manager.addCache(new Cache(Unicore6Site.class.getName(), 500, true, true, 0L, 0L));
        sitesCache = manager.getCache(Unicore6Site.class.getName());
    }
}

