/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import eu.unicore.hila.grid.ID;
import eu.unicore.hila.grid.unicore6.Unicore6Properties;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertyMD;
import eu.unicore.util.httpclient.ClientProperties;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class Unicore6SecurityProperties
extends ClientProperties
implements ID {
    private static final Logger log = Logger.getLogger(Unicore6SecurityProperties.class);
    @DocumentationReferencePrefix
    public static final String HILA_UNICORE6_BASE = "hila.unicore6";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> DEFAULTS = new HashMap<String, PropertyMD>();
    private static final String HILAUNICORE6_PROFILE_BASE = "hila.unicore6.profile";
    private Unicore6Properties properties;
    private String profile;
    private String profileBase;

    public Unicore6SecurityProperties(Unicore6Properties _props, String _profile) {
        super(_props, "hila.unicore6." + (_profile == null ? "" : _profile + ".") + "truststore.", "hila.unicore6." + (_profile == null ? "" : _profile + ".") + "credential.", "hila.unicore6." + (_profile == null ? "" : _profile + ".") + "client.");
        this.properties = _props;
        this.profile = _profile;
        if (log.isDebugEnabled()) {
            log.debug("profile == " + this.profile);
        }
        if (this.profile == null) {
            if (log.isDebugEnabled()) {
                log.debug("Using default profile");
            }
            this.profileBase = HILA_UNICORE6_BASE;
        } else {
            this.profileBase = "hila.unicore6.profile." + this.profile;
            if (log.isDebugEnabled()) {
                log.debug("Using profile base " + this.profileBase);
            }
        }
    }

    public Unicore6SecurityProperties(Unicore6Properties _props) {
        this(_props, null);
    }

    @Override
    public Unicore6SecurityProperties clone() {
        try {
            Unicore6SecurityProperties u6prop = (Unicore6SecurityProperties)super.clone();
            u6prop.profile = this.profile != null ? new String(this.profile) : null;
            u6prop.properties = (Unicore6Properties)this.properties.clone();
            u6prop.profileBase = this.profileBase != null ? new String(this.profileBase) : null;
            return u6prop;
        }
        catch (ClassCastException e) {
            log.error("ClassCastException in clone(): this indicates an unconventional implementation of clone() in a superclass of " + this.getClass().getName());
        }
        catch (Exception e) {
            log.error("Exception in clone()", e);
        }
        return this;
    }

    static {
        PropertyMD.DocumentationCategory documentationCategory = new PropertyMD.DocumentationCategory("Main", "a");
    }
}

