/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import eu.unicore.hila.HiLA;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Progressable;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.grid.unicore6.TasksHelper;
import eu.unicore.hila.grid.unicore6.Unicore6File;
import eu.unicore.hila.grid.unicore6.Unicore6ImportTask;
import eu.unicore.hila.grid.unicore6.Unicore6ImportsCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;

public class Unicore6RecursiveImportTask
extends Unicore6ImportTask
implements SimpleTransfer,
Callable<TaskStatus>,
Progressable {
    private final Unicore6File destination;
    private final List<SimpleTransfer> transfers;
    private final File source;
    private boolean abort = false;
    private boolean allCreated = false;

    public Unicore6RecursiveImportTask(File _source, Unicore6File _destination) throws HiLAException {
        super(_destination.getStorage().getLocation().getChildLocation("imports").getChildLocation(UUID.randomUUID().toString()));
        this.source = _source;
        this.destination = _destination;
        this.transfers = new ArrayList<SimpleTransfer>();
        this.setCurrentState(TaskStatus.NEW);
        HiLA.getExecutor().submit(this);
        Unicore6ImportsCollection ic = (Unicore6ImportsCollection)this.getParent();
        if (ic != null) {
            ic.addTask(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() throws HiLAException {
        this.abort = true;
        Unicore6RecursiveImportTask unicore6RecursiveImportTask = this;
        synchronized (unicore6RecursiveImportTask) {
            if (!this.allCreated) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        for (SimpleTransfer transfer : this.transfers) {
            transfer.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus call() throws Exception {
        this.setCurrentState(TaskStatus.RUNNING);
        if (!this.destination.exists()) {
            this.destination.mkdir();
        }
        Unicore6RecursiveImportTask unicore6RecursiveImportTask = this;
        synchronized (unicore6RecursiveImportTask) {
            List<File> files = Arrays.asList(this.source.listFiles());
            for (File file : files) {
                this.transfers.add(this.destination.importFromLocalFile(file, false, true));
                if (!this.abort) continue;
                break;
            }
            this.allCreated = true;
            this.notify();
        }
        while (TasksHelper.hasPendingTasks(this.transfers)) {
            Thread.sleep(500L);
        }
        if (!TasksHelper.allTasksSuccessful(this.transfers)) {
            HiLAException e = new HiLAException("Not all transfers were successful.");
            this.setCurrentState(TaskStatus.FAILED, e);
            throw e;
        }
        this.setCurrentState(TaskStatus.SUCCESSFUL);
        return this.status();
    }
}

