/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import eu.unicore.hila.HiLA;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.Progressable;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.grid.unicore6.TasksHelper;
import eu.unicore.hila.grid.unicore6.Unicore6ExportTask;
import eu.unicore.hila.grid.unicore6.Unicore6ExportsCollection;
import eu.unicore.hila.grid.unicore6.Unicore6File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;

public class Unicore6RecursiveExportTask
extends Unicore6ExportTask
implements SimpleTransfer,
Callable<TaskStatus>,
Progressable {
    private final java.io.File destination;
    private final List<SimpleTransfer> transfers;
    private final Unicore6File source;
    private boolean abort = false;
    private boolean allCreated = false;

    public Unicore6RecursiveExportTask(Unicore6File _source, java.io.File _destination) throws HiLAException {
        super(_source.getStorage().getLocation().getChildLocation("exports").getChildLocation(UUID.randomUUID().toString()));
        this.source = _source;
        this.destination = _destination;
        this.transfers = new ArrayList<SimpleTransfer>();
        this.setCurrentState(TaskStatus.NEW);
        HiLA.getExecutor().submit(this);
        Unicore6ExportsCollection ec = (Unicore6ExportsCollection)this.getParent();
        if (ec != null) {
            ec.addTask(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() throws HiLAException {
        this.abort = true;
        Unicore6RecursiveExportTask unicore6RecursiveExportTask = this;
        synchronized (unicore6RecursiveExportTask) {
            if (!this.allCreated) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        for (SimpleTransfer transfer : this.transfers) {
            transfer.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus call() throws Exception {
        this.setCurrentState(TaskStatus.RUNNING);
        if (!this.destination.exists()) {
            this.destination.mkdir();
        }
        Unicore6RecursiveExportTask unicore6RecursiveExportTask = this;
        synchronized (unicore6RecursiveExportTask) {
            List<File> files = this.source.ls();
            for (File file : files) {
                this.transfers.add(file.exportToLocalFile(this.destination, false, true));
                if (!this.abort) continue;
                break;
            }
            this.allCreated = true;
            this.notify();
        }
        while (TasksHelper.hasPendingTasks(this.transfers)) {
            Thread.sleep(500L);
        }
        if (!TasksHelper.allTasksSuccessful(this.transfers)) {
            HiLAException e = new HiLAException("Not all transfers were successful.");
            this.setCurrentState(TaskStatus.FAILED, e);
            throw e;
        }
        this.setCurrentState(TaskStatus.SUCCESSFUL);
        return this.status();
    }
}

