/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.unicore6.ServiceOrchestratorLocator;
import eu.unicore.hila.grid.unicore6.Unicore6Grid;
import eu.unicore.hila.grid.unicore6.Unicore6Properties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

@ResourceType(locationStructure={"unicore6:/orchestrators/?", "unicore6:/{user}@orchestrators/?"})
public class Unicore6OrchestratorsCollection
extends BaseResource {
    private static final Logger log = Logger.getLogger(Unicore6OrchestratorsCollection.class);
    private static HashMap<Location, Unicore6OrchestratorsCollection> orchestratorsCollections = new HashMap();
    private List<Resource> orchestrators = new ArrayList<Resource>();
    private long orchestratorsTimestamp = 0L;

    private Unicore6OrchestratorsCollection(Location _location) {
        super(_location);
    }

    public static Unicore6OrchestratorsCollection locate(Location _location, Object ... _extraInformation) {
        if (orchestratorsCollections.containsKey(_location)) {
            return orchestratorsCollections.get(_location);
        }
        Unicore6OrchestratorsCollection orchestratorsCollection = new Unicore6OrchestratorsCollection(_location);
        orchestratorsCollections.put(_location, orchestratorsCollection);
        return orchestratorsCollection;
    }

    public List<Resource> getChildren() throws HiLAException {
        Unicore6Grid parent = (Unicore6Grid)this.getParent();
        Unicore6Properties props = parent.getProperties();
        List<String> registryUrls = props.getRegistryUrls();
        if (this.orchestrators.isEmpty() || System.currentTimeMillis() - this.orchestratorsTimestamp > 60000L) {
            if (log.isDebugEnabled()) {
                log.debug("Updating orchestrators list.");
            }
            this.orchestrators.clear();
            this.orchestrators.addAll(ServiceOrchestratorLocator.getInstance().getAllOrchestrators(registryUrls, props, 5000L, this.location));
            this.orchestratorsTimestamp = System.currentTimeMillis();
        }
        return this.orchestrators;
    }
}

