/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.TSSClient;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseJob;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.Grid;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.StatusChangeListener;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.grid.unicore6.GetSitesFromTSF;
import eu.unicore.hila.grid.unicore6.Unicore6SecurityProperties;
import eu.unicore.hila.grid.unicore6.Unicore6Site;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chemomentum.common.ws.IServiceOrchestrator;
import org.chemomentum.workassignment.xmlbeans.CancelResultType;
import org.chemomentum.workassignment.xmlbeans.CancelWorkAssignmentRequestDocument;
import org.chemomentum.workassignment.xmlbeans.CancelWorkAssignmentResponseDocument;
import org.chemomentum.workassignment.xmlbeans.GetWorkAssignmentStatusRequestDocument;
import org.chemomentum.workassignment.xmlbeans.GetWorkAssignmentStatusResponseDocument;
import org.chemomentum.workassignment.xmlbeans.StatusType;
import org.unigrids.x2006.x04.services.jms.TargetSystemReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

@ResourceType(locationStructure={"unicore6:/orchestrators/{orchestrator}/{task}/?", "unicore6:/{user}@orchestrators/{orchestrator}/{task}/?"})
public class Unicore6OrchestratorJob
extends BaseJob
implements Job {
    private IServiceOrchestrator orchestrator;
    private Job realJob;
    private IClientConfiguration secprops;
    private static final Map<Location, Unicore6OrchestratorJob> jobsCache = new HashMap<Location, Unicore6OrchestratorJob>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Unicore6OrchestratorJob(Location _location, IServiceOrchestrator _orchestrator, Unicore6SecurityProperties secprop) {
        super(_location);
        this.orchestrator = _orchestrator;
        this.secprops = secprop;
        Map<Location, Unicore6OrchestratorJob> map = jobsCache;
        synchronized (map) {
            jobsCache.put(_location, this);
        }
    }

    public static synchronized Resource locate(Location _location, Object ... _extraInformation) throws HiLAFactoryException {
        if (jobsCache.containsKey(_location)) {
            return (Resource)jobsCache.get(_location);
        }
        throw new HiLAFactoryException("This task does not exist.");
    }

    public void abort() throws HiLAException {
        CancelWorkAssignmentRequestDocument cwareqd = CancelWorkAssignmentRequestDocument.Factory.newInstance();
        cwareqd.addNewCancelWorkAssignmentRequest().setId(this.getId());
        CancelWorkAssignmentResponseDocument cwaresd = this.orchestrator.cancelWorkAssignment(cwareqd);
        CancelResultType.Enum result = cwaresd.getCancelWorkAssignmentResponse().getCancelResult();
        if (result.equals(CancelResultType.FAILURE)) {
            throw new HiLAException("Unable to cancel work assignment.");
        }
    }

    public String getId() throws HiLAException {
        return this.location.getName();
    }

    @Override
    public TaskStatus startSync(java.io.File ... imports) throws HiLAException {
        if (imports.length > 0) {
            throw new HiLAException("Cannot import local files into brokered job.");
        }
        return this.status();
    }

    @Override
    public TaskStatus status() throws HiLAException {
        GetWorkAssignmentStatusRequestDocument gwasreqd = GetWorkAssignmentStatusRequestDocument.Factory.newInstance();
        gwasreqd.addNewGetWorkAssignmentStatusRequest().setId(this.getId());
        GetWorkAssignmentStatusResponseDocument gwasresd = this.orchestrator.getWorkAssignmentStatus(gwasreqd);
        StatusType.Enum result = gwasresd.getGetWorkAssignmentStatusResponse().getStatusResult();
        if (result.equals(StatusType.CANCELED)) {
            return TaskStatus.ABORTED;
        }
        if (result.equals(StatusType.FAILURE)) {
            return TaskStatus.FAILED;
        }
        if (result.equals(StatusType.SUCCESS)) {
            return TaskStatus.SUCCESSFUL;
        }
        if (result.equals(StatusType.RUNNING)) {
            return TaskStatus.RUNNING;
        }
        return TaskStatus.NEW;
    }

    public void startASync(java.io.File ... imports) throws HiLAException {
        this.startSync(imports);
    }

    @Override
    public TaskStatus startASync(StatusChangeListener listener, java.io.File ... imports) throws HiLAException {
        this.startASync(imports);
        this.registerStatusChangeListener(listener);
        return this.status();
    }

    public List<SimpleTransfer> cleanup(File ... exports) throws HiLAException {
        if (exports.length > 0) {
            throw new HiLAException("Cannot export files from brokered job.");
        }
        throw new HiLANotImplementedException("Cleanup");
    }

    public int getExitCode() throws HiLAException {
        if (this.getRealJob() == null) {
            throw new HiLAException("exit code not accessible");
        }
        return this.realJob.getExitCode();
    }

    public String getLog() throws HiLAException {
        if (this.getRealJob() == null) {
            throw new HiLAException("Job log not accessible");
        }
        return this.realJob.getLog();
    }

    public File getStdErr() throws HiLAException {
        if (this.getRealJob() == null) {
            throw new HiLAException("stderr not accessible");
        }
        return null;
    }

    public File getStdOut() throws HiLAException {
        if (this.getRealJob() == null) {
            throw new HiLAException("stdout not accessible");
        }
        return this.realJob.getStdOut();
    }

    @Override
    public Calendar getSubmissionTime() throws HiLAException {
        if (this.getRealJob() == null) {
            throw new HiLAException("Job submission time not accessible.");
        }
        return this.realJob.getSubmissionTime();
    }

    public File getWorkingDirectory() throws HiLAException {
        if (this.getRealJob() == null) {
            throw new HiLAException("Working directory not accessible.");
        }
        return this.realJob.getWorkingDirectory();
    }

    private synchronized Job getRealJob() throws HiLAException {
        if (this.realJob == null) {
            GetWorkAssignmentStatusRequestDocument gwasreqd = GetWorkAssignmentStatusRequestDocument.Factory.newInstance();
            gwasreqd.addNewGetWorkAssignmentStatusRequest().setId(this.getId());
            GetWorkAssignmentStatusResponseDocument gwasresd = this.orchestrator.getWorkAssignmentStatus(gwasreqd);
            if (gwasresd.getGetWorkAssignmentStatusResponse().isSetExecutionResources()) {
                EndpointReferenceType jobEpr = gwasresd.getGetWorkAssignmentStatusResponse().getExecutionResources().getJob();
                this.realJob = this.getJobFromEpr(jobEpr);
            }
        }
        return this.realJob;
    }

    @Override
    public List<Resource> getChildren() throws HiLAException {
        if (this.getRealJob() == null) {
            throw new HiLAException("No children available (yet).");
        }
        return Collections.singletonList(this.getRealJob());
    }

    private Job getJobFromEpr(EndpointReferenceType jobEpr) throws HiLAException {
        try {
            JobClient jobClient = new JobClient(jobEpr.getAddress().getStringValue(), jobEpr, this.secprops);
            TargetSystemReferenceDocument tsrd = TargetSystemReferenceDocument.Factory.parse(jobClient.getResourceProperty(TargetSystemReferenceDocument.type.getDocumentElementName()));
            TSSClient tssClient = new TSSClient(tsrd.getTargetSystemReference().getAddress().getStringValue(), tsrd.getTargetSystemReference(), this.secprops);
            Calendar upSince = tssClient.getUpSince();
            String dateString = GetSitesFromTSF.constructDateString(upSince);
            String tsName = tssClient.getTargetSystemName();
            Location gridLoc = Unicore6OrchestratorJob.findParentLocationOfType(Grid.class, (Location)this.location, Grid.class);
            Job job = (Job)gridLoc.getChildLocation("sites").getChildLocation(tsName.concat("_").concat(dateString)).getChildLocation("tasks").getChildLocation(Unicore6Site.epr2TaskId(jobEpr)).locate(new Object[0]);
            return job;
        }
        catch (Exception e) {
            throw new HiLAException("Unable to access the real job.", (Throwable)e);
        }
    }
}

