/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.JobManagement;
import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.InvalidResourcePropertyQNameFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.Metadata;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseJob;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationPatternException;
import eu.unicore.hila.exceptions.HiLAResourceAlreadyExistsException;
import eu.unicore.hila.exceptions.HiLAResourceNotFoundException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.grid.unicore6.CleanupAction;
import eu.unicore.hila.grid.unicore6.Unicore6Grid;
import eu.unicore.hila.grid.unicore6.Unicore6Site;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.xmlbeans.XmlException;
import org.unigrids.x2006.x04.services.jms.LogDocument;
import org.unigrids.x2006.x04.services.jms.OriginalJSDLDocument;

@ResourceType(locationStructure={"unicore6:/sites/{site}/tasks/{task}/?", "unicore6:/{user}@sites/{site}/tasks/{task}/?"})
public class Unicore6Job
extends BaseJob
implements Job {
    private static final Cache tasksCache;
    protected final JobClient jobClient;
    private Metadata metadata;
    private static Map<String, TaskStatus> statusMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Unicore6Job(Location _location, JobClient _jobClient) throws HiLAException {
        super(_location);
        if (tasksCache.isKeyInCache(_location)) {
            throw new HiLAResourceAlreadyExistsException();
        }
        this.jobClient = _jobClient;
        Cache cache = tasksCache;
        synchronized (cache) {
            tasksCache.put(new Element(_location, (Object)this));
        }
    }

    public static Resource locate(Location _location, Object ... _extraInformation) throws HiLAException {
        Element cacheElem;
        if (tasksCache.isKeyInCache(_location) && (cacheElem = tasksCache.get(_location)) != null) {
            return (Resource)cacheElem.getObjectValue();
        }
        return ((Unicore6Site)Unicore6Job.findParentLocationOfType(Unicore6Site.class, (Location)_location, Unicore6Grid.class).locate(new Object[0])).getTask(_location.getName());
    }

    public void abort() throws HiLAException {
        try {
            this.jobClient.abort();
        }
        catch (Exception e) {
            throw new HiLAException("Job abort failed", (Throwable)e);
        }
    }

    public String getId() {
        return this.location.getName();
    }

    @Override
    public Site getSite() throws HiLALocationPatternException, HiLAException {
        return (Site)Unicore6Job.findParentLocationOfType(Unicore6Site.class, (Location)this.location, Unicore6Grid.class).locate(new Object[0]);
    }

    @Override
    public TaskStatus status() throws HiLAException {
        if (super.status() != null && super.status().isFinalState()) {
            return super.status();
        }
        return this.updateStatus();
    }

    private TaskStatus updateStatus() throws HiLAException {
        try {
            String jobStatus = this.jobClient.getStatus().toString();
            if (jobStatus != null) {
                TaskStatus status = statusMap.get(jobStatus);
                this.setCurrentState(status);
                return status;
            }
            throw new HiLAException("Unable to determine Task status: null");
        }
        catch (Exception e) {
            throw new HiLAException("Unable to determine Task status", (Throwable)e);
        }
    }

    public void startASync(java.io.File ... files) throws HiLAException {
        try {
            boolean allDone;
            ArrayList<SimpleTransfer> imports = new ArrayList<SimpleTransfer>();
            for (java.io.File file : files) {
                imports.add(this.getWorkingDirectory().importFromLocalFile(file));
            }
            do {
                allDone = true;
                for (SimpleTransfer simpleTransfer : imports) {
                    allDone = allDone && simpleTransfer.status().equals((Object)TaskStatus.SUCCESSFUL);
                }
            } while (!allDone);
            this.jobClient.start();
        }
        catch (Exception e) {
            HiLAException e2 = new HiLAException("startASync of Task failed.", (Throwable)e);
            this.setCurrentState(TaskStatus.FAILED, e2);
            throw e2;
        }
    }

    public List<SimpleTransfer> cleanup(File ... exports) throws HiLAException {
        ArrayList<SimpleTransfer> transfers = new ArrayList<SimpleTransfer>();
        if (exports != null && exports.length > 0) {
            java.io.File localDir;
            java.io.File localDataDir = new java.io.File(new java.io.File(System.getProperty("user.home")), ".hila2/data");
            if (!localDataDir.exists()) {
                if (!localDataDir.mkdirs()) {
                    throw new HiLAException("Unable to create local directory for exports: " + localDataDir.getAbsolutePath());
                }
            } else if (!localDataDir.isDirectory()) {
                throw new HiLAException("Local file " + localDataDir.getAbsolutePath() + " blocks task output directory.");
            }
            if (!(localDir = new java.io.File(localDataDir, this.getId())).mkdir()) {
                throw new HiLAException("Unable to create local directory for export: " + localDir.getAbsolutePath());
            }
            for (File exportFile : exports) {
                transfers.add(exportFile.exportToLocalFile(localDir));
            }
        }
        CleanupAction cleanup = new CleanupAction(transfers, this);
        HiLA.getExecutor().submit(cleanup);
        return transfers;
    }

    public int getExitCode() {
        return this.jobClient.getExitCode();
    }

    public String getLog() throws HiLAException {
        try {
            LogDocument ld = LogDocument.Factory.parse(this.jobClient.getResourceProperty(JobManagement.RPLog));
            return ld.getLog();
        }
        catch (InvalidResourcePropertyQNameFault e) {
            throw new HiLAException("Unable to get job log.", (Throwable)e);
        }
        catch (BaseFault e) {
            throw new HiLAException("Unable to get job log.", (Throwable)e);
        }
        catch (ResourceUnavailableFault e) {
            throw new HiLAException("Unable to get job log.", (Throwable)e);
        }
        catch (ResourceUnknownFault e) {
            throw new HiLAException("Unable to get job log.", (Throwable)e);
        }
        catch (ClientException e) {
            throw new HiLAException("Unable to get job log.", (Throwable)e);
        }
        catch (XmlException e) {
            throw new HiLAException("Unable to parse job log.", (Throwable)e);
        }
    }

    public File getStdErr() throws HiLAException {
        return (File)this.getWorkingDirectory().getChild("stderr");
    }

    public File getStdOut() throws HiLAException {
        return (File)this.getWorkingDirectory().getChild("stdout");
    }

    @Override
    public Calendar getSubmissionTime() throws HiLAException {
        return this.jobClient.getSubmissionTime();
    }

    @Override
    public String getTaskName() throws HiLAException {
        try {
            OriginalJSDLDocument jsdl = OriginalJSDLDocument.Factory.parse(this.jobClient.getResourceProperty(OriginalJSDLDocument.type.getDocumentElementName()));
            if (jsdl.getOriginalJSDL().getJobDescription().isSetJobIdentification() && jsdl.getOriginalJSDL().getJobDescription().getJobIdentification().isSetJobName()) {
                return jsdl.getOriginalJSDL().getJobDescription().getJobIdentification().getJobName();
            }
            return super.getTaskName();
        }
        catch (InvalidResourcePropertyQNameFault e) {
            throw new HiLAException("Unknown Resource property.", (Throwable)e);
        }
        catch (BaseFault e) {
            throw new HiLAException("Unable to retrieve task name.", (Throwable)e);
        }
        catch (ResourceUnavailableFault e) {
            throw new HiLAResourceNotFoundException("Job resource unavailable.", (Throwable)e);
        }
        catch (ResourceUnknownFault e) {
            throw new HiLAResourceNotFoundException("Job resource unavailable.", (Throwable)e);
        }
        catch (ClientException e) {
            throw new HiLAException("Unable to retrieve task name.", (Throwable)e);
        }
        catch (XmlException e) {
            throw new HiLAException("Server returned invalid resource property.", (Throwable)e);
        }
    }

    public File getWorkingDirectory() throws HiLAException {
        try {
            StorageClient wdStorageClient = this.jobClient.getUspaceClient();
            Location wdLoc = this.location.getChildLocation("wd").getChildLocation("files");
            return (File)wdLoc.locate(new Object[]{wdStorageClient});
        }
        catch (Exception e) {
            throw new HiLAException("Unable to access working directory of task " + this.location + ".", (Throwable)e);
        }
    }

    @Override
    public void hold() throws HiLAException {
        try {
            this.jobClient.hold();
        }
        catch (Exception e) {
            throw new HiLAException("cannot hold job", (Throwable)e);
        }
    }

    @Override
    public void resume() throws HiLAException {
        try {
            this.jobClient.resume();
        }
        catch (Exception e) {
            throw new HiLAException("cannot resume job", (Throwable)e);
        }
    }

    @Override
    public Metadata getMetadata() throws HiLAException {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        try {
            this.metadata.setData("resourceProperties", (Object)this.jobClient.getResourcePropertyDocument());
        }
        catch (BaseFault e) {
            throw new HiLAException("resourceProperties unavailable", (Throwable)e);
        }
        catch (ResourceUnknownFault e) {
            throw new HiLAResourceNotFoundException("resourceProperties unavailable", (Throwable)e);
        }
        catch (ResourceUnavailableFault e) {
            throw new HiLAResourceNotFoundException("resourceProperties unavailable", (Throwable)e);
        }
        catch (ClientException e) {
            throw new HiLAException("resourceProperties unavailable", (Throwable)e);
        }
        return this.metadata;
    }

    protected static void removeFromCache(Unicore6Job job) {
        tasksCache.remove(job.location);
    }

    static {
        CacheManager manager = CacheManager.getInstance();
        manager.addCache(new Cache(Unicore6Job.class.getName(), 10000, true, true, 0L, 0L));
        tasksCache = manager.getCache(Unicore6Job.class.getName());
        statusMap = new Hashtable<String, TaskStatus>();
        statusMap.put("READY", TaskStatus.NEW);
        statusMap.put("UNDEFINED", TaskStatus.NEW);
        statusMap.put("STAGINGIN", TaskStatus.NEW);
        statusMap.put("QUEUED", TaskStatus.PENDING);
        statusMap.put("RUNNING", TaskStatus.RUNNING);
        statusMap.put("STAGINGOUT", TaskStatus.RUNNING);
        statusMap.put("SUCCESSFUL", TaskStatus.SUCCESSFUL);
        statusMap.put("FAILED", TaskStatus.FAILED);
    }
}

