/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseSimpleTransfer;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.exceptions.HiLAResourceNotFoundException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.grid.unicore6.Unicore6ImportsCollection;
import eu.unicore.hila.grid.unicore6.util.FileTransfers;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;

@ResourceType(locationStructure={"unicore6:/sites/{site}/storages/{storage}/imports/{import}", "unicore6:/{user}@sites/{site}/storages/{storage}/imports/{import}", "unicore6:/sites/{site}/tasks/{task}/wd/imports/{import}", "unicore6:/{user}@sites/{site}/tasks/{task}/wd/imports/{import}", "unicore6:/storages/{storage}/imports/{import}", "unicore6:/{user}@storages/{storage}/imports/{import}"})
public class Unicore6ImportTask
extends BaseSimpleTransfer
implements SimpleTransfer,
Callable<TaskStatus> {
    private StorageClient storageClient;
    private String path;
    private File remoteFile;
    private java.io.File localFile;
    private boolean overwrite;
    private FileTransferClient importClient;
    private long maxBytes;
    private long currentBytes;

    public Unicore6ImportTask(Location _storageLocation, StorageClient _storageClient, String _path, File _remoteFile, java.io.File _localFile, boolean _overwrite) throws HiLAException {
        super(_storageLocation.getChildLocation("imports").getChildLocation(UUID.randomUUID().toString()));
        this.storageClient = _storageClient;
        this.path = _path;
        this.remoteFile = _remoteFile;
        this.localFile = _localFile;
        this.overwrite = _overwrite;
        this.setCurrentState(TaskStatus.PENDING);
        HiLA.getExecutor().submit(this);
        Unicore6ImportsCollection ic = (Unicore6ImportsCollection)this.getParent();
        if (ic != null) {
            ic.addTask(this);
        }
    }

    protected Unicore6ImportTask(Location _location) {
        super(_location);
    }

    public static synchronized Unicore6ImportTask locate(Location _location, Object ... _extrainformation) throws HiLAException {
        Resource importsRes = _location.getParentLocation().locate(new Object[0]);
        List imports = importsRes.getChildren();
        for (Resource resource : imports) {
            if (!resource.getLocation().equals((Object)_location)) continue;
            return (Unicore6ImportTask)resource;
        }
        throw new HiLAResourceNotFoundException("This Import does not exist: " + _location);
    }

    @Override
    public TaskStatus call() throws Exception {
        block16: {
            this.setCurrentState(TaskStatus.RUNNING);
            if (!this.localFile.exists()) {
                HiLAException e = new HiLAException("No such file or directory.");
                this.setCurrentState(TaskStatus.FAILED, e);
                throw e;
            }
            if (this.storageClient != null) {
                InputStream fis = null;
                try {
                    HashMap<String, String> extraParameters = new HashMap<String, String>();
                    FileTransfers.getDefaultUftpParameters(extraParameters);
                    this.importClient = this.storageClient.getImport(this.path, false, extraParameters, FileTransfers.getFTPrefs());
                    if (this.overwrite || !this.remoteFile.exists()) {
                        fis = new FileInputStream(this.localFile);
                        this.importClient.writeAllData(fis);
                        fis.close();
                        break block16;
                    }
                    HiLAException e = new HiLAException("File exists, but may not be overwritten.");
                    this.setCurrentState(TaskStatus.FAILED, e);
                    this.importClient.destroy();
                    this.importClient = null;
                    throw e;
                }
                catch (IOException e) {
                    HiLAException e2 = new HiLAException("Unable to import from local file.", (Throwable)e);
                    this.setCurrentState(TaskStatus.FAILED, e2);
                    if (this.importClient != null) {
                        this.importClient.destroy();
                        this.importClient = null;
                    }
                    throw e2;
                }
                catch (Exception e) {
                    HiLAException e2 = new HiLAException("Unable to write data to remote file.", (Throwable)e);
                    this.setCurrentState(TaskStatus.FAILED, e2);
                    if (this.importClient != null) {
                        this.importClient.destroy();
                        this.importClient = null;
                    }
                    throw e2;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        this.setCurrentState(TaskStatus.SUCCESSFUL);
        this.importClient.destroy();
        this.importClient = null;
        return this.status();
    }

    public synchronized void abort() throws HiLAException {
        try {
            if (this.importClient != null) {
                this.importClient.destroy();
                this.importClient = null;
            }
        }
        catch (BaseFault e) {
            throw new HiLAException(e.getMessage(), (Throwable)e);
        }
        catch (ResourceUnavailableFault e) {
            throw new HiLAException(e.getMessage(), (Throwable)e);
        }
        catch (ResourceUnknownFault e) {
            throw new HiLAException(e.getMessage(), (Throwable)e);
        }
        catch (ResourceNotDestroyedFault e) {
            throw new HiLAException(e.getMessage(), (Throwable)e);
        }
        catch (ClientException e) {
            throw new HiLAException(e.getMessage(), (Throwable)e);
        }
    }

    public String getId() {
        return this.location.getName();
    }

    public List<Resource> getChildren() throws HiLAException {
        ArrayList<Resource> children = new ArrayList<Resource>();
        return children;
    }

    @Override
    public String getUnit() throws HiLANotImplementedException {
        return "bytes";
    }

    @Override
    public synchronized long getMax() throws HiLAException {
        if (this.importClient != null) {
            this.maxBytes = this.localFile.length();
        }
        return this.maxBytes;
    }

    @Override
    public synchronized long getCurrent() throws HiLAException {
        if (this.importClient != null) {
            try {
                this.currentBytes = this.importClient.getTransferredBytes();
            }
            catch (Exception e) {
                throw new HiLAException("Unable to determine transfer progress.", (Throwable)e);
            }
        }
        return this.currentBytes;
    }
}

