/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseGrid;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.grid.Grid;
import eu.unicore.hila.grid.unicore6.Unicore6Properties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@ResourceType(locationStructure={"unicore6:/"})
public class Unicore6Grid
extends BaseGrid
implements Grid {
    private static final Logger log = Logger.getLogger(Unicore6Grid.class);
    private static volatile Unicore6Grid theInstance = null;
    private static final Object theInstanceLock = new Object();
    public static final String CONFIG_KEY = "hila2.unicore6.config";
    private final Unicore6Properties properties = new Unicore6Properties();

    private Unicore6Grid(Location _location) throws HiLAException {
        super(_location);
        this.initialize();
    }

    private void initialize() throws HiLAException {
        InputStream configIS = null;
        try {
            String config = System.getProperty(CONFIG_KEY);
            if (config != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Using UNICORE 6 configuration as defined by system property hila2.unicore6.config: " + config);
                }
                File configFile = new File(config);
                configIS = new FileInputStream(configFile);
                this.properties.load(configIS);
                this.properties.setConfigBase(configFile.getParentFile().getAbsoluteFile());
                return;
            }
        }
        catch (FileNotFoundException e) {
            throw new HiLAFactoryException("Cannot find configuration file.", (Throwable)e);
        }
        catch (IOException e) {
            throw new HiLAFactoryException("Cannot open configuration file.", (Throwable)e);
        }
        finally {
            if (configIS != null) {
                try {
                    configIS.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close config file input stream.", e);
                }
            }
        }
        try {
            File configFile = new File("unicore6.properties");
            configIS = new FileInputStream(configFile);
            this.properties.load(configIS);
            this.properties.setConfigBase(configFile.getParentFile().getAbsoluteFile());
            return;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new HiLAException("Cannot read configuration file unicore6.properties from current directory.", (Throwable)e);
        }
        finally {
            if (configIS != null) {
                try {
                    configIS.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close config file input stream", e);
                }
            }
        }
        try {
            File configFile = new File(System.getProperty("user.home") + File.separator + ".hila2" + File.separator + "unicore6.properties");
            configIS = new FileInputStream(configFile);
            this.properties.load(configIS);
            this.properties.setConfigBase(configFile.getParentFile().getAbsoluteFile());
            return;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new HiLAException("Cannot read configuration file unicore6.properties from ~/.hila2.", (Throwable)e);
        }
        finally {
            if (configIS != null) {
                try {
                    configIS.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close config file input stream", e);
                }
            }
        }
        try {
            configIS = ((Object)((Object)this)).getClass().getResourceAsStream("/unicore6.properties");
            if (configIS == null) {
                throw new HiLAFactoryException("Unable to find useable UNICORE 6 configuration.");
            }
            this.properties.load(configIS);
        }
        catch (IOException e) {
            throw new HiLAFactoryException("Unable to read unicore6.properties from classpath", (Throwable)e);
        }
        finally {
            if (configIS != null) {
                try {
                    configIS.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close config file input stream", e);
                }
            }
        }
        if (log.isTraceEnabled()) {
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                log.trace(entry.getKey() + " : " + entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Unicore6Grid locate(Location _location) throws HiLAException {
        if (theInstance == null) {
            Object object = theInstanceLock;
            synchronized (object) {
                if (theInstance == null) {
                    theInstance = new Unicore6Grid(_location);
                }
            }
        }
        return theInstance;
    }

    @Override
    public List<Resource> getChildren() throws HiLAException {
        ArrayList<Resource> children = new ArrayList<Resource>();
        children.add(this.location.getChildLocation("sites").locate(new Object[0]));
        children.add(this.location.getChildLocation("storages").locate(new Object[0]));
        children.add(this.location.getChildLocation("orchestrators").locate(new Object[0]));
        return children;
    }

    public Unicore6Properties getProperties() {
        return this.properties;
    }
}

