/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.StorageManagement;
import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Config;
import eu.unicore.hila.grid.Storage;
import eu.unicore.hila.grid.unicore6.GetServicesFromRegistry;
import eu.unicore.hila.grid.unicore6.GetStorageFromEPR;
import eu.unicore.hila.grid.unicore6.Unicore6Properties;
import eu.unicore.hila.grid.unicore6.Unicore6SecurityProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class StorageLocator {
    private static final Logger log = Logger.getLogger(StorageLocator.class);
    private static volatile StorageLocator theInstance = null;
    private static Object theInstanceLock = new Object();
    private Config config;
    private Object configLock = new Object();

    protected StorageLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StorageLocator getInstance() {
        if (theInstance == null) {
            Object object = theInstanceLock;
            synchronized (object) {
                if (theInstance == null) {
                    theInstance = new StorageLocator();
                }
            }
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Storage> getAllStorages(List<String> _registryURLs, Unicore6Properties _props, long timeoutMillis, Location _parentLocation) throws HiLAException {
        Unicore6SecurityProperties secProps;
        if (this.config == null) {
            Object object = this.configLock;
            synchronized (object) {
                if (this.config == null) {
                    Constructor<?> constructor;
                    Class<?> configClass;
                    String configProviderClass = _props.getConfigImplementation();
                    try {
                        configClass = Class.forName(configProviderClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new HiLAException("hila.unicore6.config references unknown class" + configProviderClass, (Throwable)e);
                    }
                    catch (ClassCastException e) {
                        throw new HiLAException(configProviderClass + " is not a subclass of " + Config.class.getName());
                    }
                    try {
                        constructor = configClass.getConstructor(Unicore6Properties.class);
                    }
                    catch (SecurityException e) {
                        throw new HiLAException(e.getMessage(), (Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new HiLAException("Config implementation referenced in hila.unicore6.config does not provide the correct constructor", (Throwable)e);
                    }
                    try {
                        this.config = (Config)constructor.newInstance(_props);
                    }
                    catch (IllegalArgumentException e) {
                        throw new HiLAException(e.getMessage(), (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        throw new HiLAException(e.getMessage(), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new HiLAException(e.getMessage(), (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new HiLAException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        if ((secProps = (Unicore6SecurityProperties)this.config.getIdForLocation(_parentLocation)) != null) {
            secProps = secProps.clone();
        }
        ArrayList<Storage> storages = new ArrayList<Storage>();
        ArrayList<Future<List<EndpointReferenceType>>> storageEPRFutures = new ArrayList<Future<List<EndpointReferenceType>>>();
        for (String registryURL : _registryURLs) {
            GetServicesFromRegistry getSMSs = new GetServicesFromRegistry(registryURL, secProps, StorageManagement.SMS_PORT);
            storageEPRFutures.add(HiLA.getExecutor().submit(getSMSs));
        }
        long registryDeadline = System.currentTimeMillis() + timeoutMillis;
        for (Future future : storageEPRFutures) {
            try {
                List storageEPRs = (List)future.get(registryDeadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                ArrayList<Future<Storage>> storageFutures = new ArrayList<Future<Storage>>();
                for (EndpointReferenceType sEPR : storageEPRs) {
                    GetStorageFromEPR getStorageFromEPR = new GetStorageFromEPR(sEPR, secProps, _parentLocation);
                    storageFutures.add(HiLA.getExecutor().submit(getStorageFromEPR));
                }
                long storageDeadline = System.currentTimeMillis() + timeoutMillis;
                for (Future future2 : storageFutures) {
                    try {
                        storages.add((Storage)future2.get(storageDeadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS));
                    }
                    catch (InterruptedException e) {
                        log.error("Interrupted while waiting for storage service.", e);
                    }
                    catch (ExecutionException e) {
                        log.error("Error retrieving storage.", e);
                    }
                    catch (TimeoutException e) {
                        log.error("Timeout while waiting for storage service.", e);
                    }
                }
            }
            catch (InterruptedException e) {
                log.error("Interrupted while waiting for registry.", e);
            }
            catch (ExecutionException e) {
                log.error("Error retrieving storage references.", e);
            }
            catch (TimeoutException e) {
                log.error("Timeout waiting for registry.", e);
            }
        }
        return storages;
    }
}

