/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.common.grid.BaseTask;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.TaskStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class LocalTasksCollection
extends BaseResource {
    private static final Logger log = Logger.getLogger(LocalTasksCollection.class);
    protected final List<BaseTask> tasks;
    protected final Map<BaseTask, Long> finishedTasks;
    protected final LocalTasksCleaner tasksCleaner;
    private final Object lock = new Object();
    private boolean cleaningActive = false;
    private ScheduledFuture<?> tasksCleanerFuture;

    public LocalTasksCollection(Location _location) {
        super(_location);
        this.tasks = new ArrayList<BaseTask>();
        this.finishedTasks = new HashMap<BaseTask, Long>();
        this.tasksCleaner = new LocalTasksCleaner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource> getChildren() throws HiLAException {
        ArrayList<Resource> children = new ArrayList<Resource>();
        Object object = this.lock;
        synchronized (object) {
            children.addAll(this.tasks);
            children.addAll(this.finishedTasks.keySet());
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(BaseTask _task) {
        Object object = this.lock;
        synchronized (object) {
            this.tasks.add(_task);
            if (!this.cleaningActive) {
                if (log.isDebugEnabled()) {
                    log.debug("Starting periodic cleanup of local tasks for " + this.getLocation());
                }
                this.tasksCleanerFuture = HiLA.getDaemonExecutor().scheduleWithFixedDelay(this.tasksCleaner, 0L, 20L, TimeUnit.SECONDS);
                this.cleaningActive = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(BaseTask _task) {
        Object object = this.lock;
        synchronized (object) {
            if (this.tasks.contains((Object)_task)) {
                this.tasks.remove((Object)_task);
            } else if (this.finishedTasks.containsKey((Object)_task)) {
                this.finishedTasks.remove((Object)_task);
            }
            if (this.tasks.isEmpty() && this.finishedTasks.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug("Stopping periodic cleanup of local tasks for " + this.getLocation());
                }
                this.tasksCleanerFuture.cancel(false);
                this.cleaningActive = false;
            }
        }
    }

    private class LocalTasksCleaner
    implements Runnable {
        private LocalTasksCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug("Running periodic cleanup of local tasks.");
            }
            ArrayList<BaseTask> remove = new ArrayList<BaseTask>();
            Object object = LocalTasksCollection.this.lock;
            synchronized (object) {
                for (BaseTask task : LocalTasksCollection.this.tasks) {
                    try {
                        if (!task.status().equals((Object)TaskStatus.SUCCESSFUL) && !task.status().equals((Object)TaskStatus.FAILED) && !task.status().equals((Object)TaskStatus.ABORTED)) continue;
                        LocalTasksCollection.this.finishedTasks.put(task, System.currentTimeMillis());
                        remove.add(task);
                    }
                    catch (HiLAException e) {
                        log.error("Must not happen.", e);
                    }
                }
                LocalTasksCollection.this.tasks.removeAll(remove);
                remove.clear();
                for (BaseTask task : LocalTasksCollection.this.finishedTasks.keySet()) {
                    if (!((double)System.currentTimeMillis() - LocalTasksCollection.this.finishedTasks.get((Object)task).doubleValue() > 300000.0)) continue;
                    remove.add(task);
                }
                for (BaseTask task : remove) {
                    if (log.isDebugEnabled()) {
                        log.debug("Removing " + task.getLocation() + " from list of local tasks.");
                    }
                    LocalTasksCollection.this.removeTask(task);
                }
                if (log.isTraceEnabled()) {
                    log.trace("Active queue  : " + Integer.toString(LocalTasksCollection.this.tasks.size()));
                    log.trace("Finished queue: " + Integer.toString(LocalTasksCollection.this.finishedTasks.size()));
                }
            }
        }
    }
}

