/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.unicore6.Unicore6Job;
import java.util.List;
import org.apache.log4j.Logger;

public class CleanupAction
implements Runnable {
    private static final Logger log = Logger.getLogger(CleanupAction.class);
    private final List<SimpleTransfer> transfers;
    private final JobClient jobClient;
    private Unicore6Job job;

    public CleanupAction(List<SimpleTransfer> _transfers, Unicore6Job _job) {
        this.transfers = _transfers;
        this.job = _job;
        this.jobClient = _job.jobClient;
    }

    @Override
    public void run() {
        for (SimpleTransfer transfer : this.transfers) {
            try {
                transfer.block();
            }
            catch (HiLAException e) {
                log.error("Error while blocking on task export", e);
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Destroying WS Resource " + this.jobClient.getEPR().getAddress().getStringValue());
            }
            this.jobClient.destroy();
            Unicore6Job.removeFromCache(this.job);
        }
        catch (BaseFault e) {
            log.error("Unable to destroy job.", e);
        }
        catch (ResourceUnavailableFault e) {
            log.error("Unable to destroy job.", e);
        }
        catch (ResourceUnknownFault e) {
            log.error("Unable to destroy job.", e);
        }
        catch (ResourceNotDestroyedFault e) {
            log.error("Unable to destroy job.", e);
        }
        catch (ClientException e) {
            log.error("Unable to destroy job.", e);
        }
    }
}

