/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.trust;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.ns.EuGridPmaNamespacesParser;
import eu.emi.security.authn.x509.helpers.ns.EuGridPmaNamespacesStore;
import eu.emi.security.authn.x509.helpers.ns.GlobusNamespacesParser;
import eu.emi.security.authn.x509.helpers.ns.GlobusNamespacesStore;
import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import eu.emi.security.authn.x509.helpers.trust.DirectoryTrustAnchorStore;
import eu.emi.security.authn.x509.helpers.trust.TrustAnchorExt;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.crypto.digests.MD5Digest;

public class OpensslTrustAnchorStore
extends DirectoryTrustAnchorStore {
    public static final String CERT_WILDCARD = "????????.*";
    public static final String CERT_REGEXP = "^([0-9a-fA-F]{8})\\.[\\d]+$";
    private boolean loadEuGridPmaNs;
    private boolean loadGlobusNs;
    private EuGridPmaNamespacesStore pmaNsStore = new EuGridPmaNamespacesStore();
    private GlobusNamespacesStore globusNsStore = new GlobusNamespacesStore();

    public OpensslTrustAnchorStore(String basePath, Timer t, long updateInterval, boolean loadGlobusNs, boolean loadEuGridPmaNs, ObserversHandler observers) {
        super(Collections.singletonList(basePath + File.separator + CERT_WILDCARD), null, 0, t, updateInterval, CertificateUtils.Encoding.PEM, observers, true);
        this.loadEuGridPmaNs = loadEuGridPmaNs;
        this.loadGlobusNs = loadGlobusNs;
        this.update();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reloadCerts(Collection<URL> locations) {
        ArrayList<NamespacePolicy> globus = new ArrayList<NamespacePolicy>();
        ArrayList<NamespacePolicy> pma = new ArrayList<NamespacePolicy>();
        HashSet<TrustAnchorExt> tmpAnchors = new HashSet<TrustAnchorExt>();
        HashMap<URL, TrustAnchorExt> tmpLoc2anch = new HashMap<URL, TrustAnchorExt>();
        for (URL location : locations) {
            this.tryLoadCert(location, tmpAnchors, tmpLoc2anch);
            if (this.loadEuGridPmaNs) {
                this.tryLoadEuGridPmaNs(location, pma);
            }
            if (!this.loadGlobusNs) continue;
            this.tryLoadGlobusNs(location, globus);
        }
        OpensslTrustAnchorStore opensslTrustAnchorStore = this;
        synchronized (opensslTrustAnchorStore) {
            this.anchors.addAll(tmpAnchors);
            this.locations2anchors.putAll(tmpLoc2anch);
            this.pmaNsStore.setPolicies(pma);
            this.globusNsStore.setPolicies(globus);
        }
    }

    protected void tryLoadCert(URL location, Set<TrustAnchorExt> tmpAnchors, Map<URL, TrustAnchorExt> tmpLoc2anch) {
        X509Certificate cert;
        String fileHash = OpensslTrustAnchorStore.getFileHash(location, CERT_REGEXP);
        if (fileHash == null) {
            return;
        }
        try {
            cert = this.loadCert(location);
        }
        catch (Exception e) {
            this.observers.notifyObservers(location.toExternalForm(), "CA Certificate", StoreUpdateListener.Severity.ERROR, e);
            return;
        }
        String certHash = OpensslTrustAnchorStore.getOpenSSLCAHash(cert.getSubjectX500Principal());
        if (!fileHash.equalsIgnoreCase(certHash)) {
            this.observers.notifyObservers(location.toExternalForm(), "CA Certificate", StoreUpdateListener.Severity.WARNING, new Exception("The certificate won't be used as its name has incorrect subject's hash value. Should be " + certHash + " but is " + fileHash));
            return;
        }
        TrustAnchorExt anchor = new TrustAnchorExt(cert, null);
        tmpAnchors.add(anchor);
        tmpLoc2anch.put(location, anchor);
    }

    public EuGridPmaNamespacesStore getPmaNsStore() {
        return this.pmaNsStore;
    }

    public GlobusNamespacesStore getGlobusNsStore() {
        return this.globusNsStore;
    }

    protected void tryLoadGlobusNs(URL location, List<NamespacePolicy> globus) {
        String path = this.getNsFile(location, ".signing_policy");
        if (path == null) {
            return;
        }
        GlobusNamespacesParser parser = new GlobusNamespacesParser(path);
        try {
            globus.addAll(parser.parse());
            this.observers.notifyObservers(path, "EACL namespace (signing_policy)", StoreUpdateListener.Severity.NOTIFICATION, null);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            this.observers.notifyObservers(path, "EACL namespace (signing_policy)", StoreUpdateListener.Severity.ERROR, e);
        }
    }

    protected void tryLoadEuGridPmaNs(URL location, List<NamespacePolicy> list) {
        String path = this.getNsFile(location, ".namespaces");
        if (path == null) {
            return;
        }
        EuGridPmaNamespacesParser parser = new EuGridPmaNamespacesParser(path);
        try {
            list.addAll(parser.parse());
            this.observers.notifyObservers(path, "EUGridPMA namespace", StoreUpdateListener.Severity.NOTIFICATION, null);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            this.observers.notifyObservers(path, "EUGridPMA namespace", StoreUpdateListener.Severity.ERROR, e);
        }
    }

    private String getNsFile(URL certLocation, String suffix) {
        String fileHash = OpensslTrustAnchorStore.getFileHash(certLocation, CERT_REGEXP);
        if (fileHash == null) {
            return null;
        }
        File f = new File(certLocation.getPath());
        String parent = f.getParent();
        if (parent == null) {
            parent = ".";
        }
        return parent + File.separator + fileHash + suffix;
    }

    public static String getFileHash(URL location, String regexp) {
        return OpensslTrustAnchorStore.getFileHash(location.getPath(), regexp);
    }

    public static String getFileHash(String path, String regexp) {
        File f = new File(path);
        String name = f.getName();
        Pattern pattern = Pattern.compile(regexp);
        Matcher m = pattern.matcher(name);
        if (!m.matches()) {
            return null;
        }
        return m.group(1);
    }

    public static String getOpenSSLCAHash(X500Principal name) {
        byte[] bytes = name.getEncoded();
        MD5Digest digest = new MD5Digest();
        digest.update(bytes, 0, bytes.length);
        byte[] output = new byte[16];
        digest.doFinal(output, 0);
        return String.format("%02x%02x%02x%02x", output[3] & 0xFF, output[2] & 0xFF, output[1] & 0xFF, output[0] & 0xFF);
    }
}

