/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.crl;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.crl.PlainCRLStoreSpi;
import eu.emi.security.authn.x509.helpers.trust.OpensslTrustAnchorStore;
import eu.emi.security.authn.x509.impl.CRLParameters;
import java.io.File;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.X509CRL;
import java.util.Collection;
import java.util.Collections;
import java.util.Timer;

public class OpensslCRLStoreSpi
extends PlainCRLStoreSpi {
    public static final String CRL_WILDCARD = "????????.r*";

    public OpensslCRLStoreSpi(String path, long crlUpdateInterval, Timer t, ObserversHandler observers) throws InvalidAlgorithmParameterException {
        super(new CRLParameters(Collections.singletonList(path + File.separator + CRL_WILDCARD), crlUpdateInterval, 0, null), t, observers);
    }

    @Override
    protected void reloadCRLs(Collection<URL> locations) {
        for (URL location : locations) {
            X509CRL crl;
            String fileHash = OpensslTrustAnchorStore.getFileHash(location, "^([0-9a-fA-F]{8})\\.r[\\d]+$");
            if (fileHash == null) continue;
            try {
                crl = this.loadCRL(location);
            }
            catch (Exception e) {
                this.notifyObservers(location.toExternalForm(), StoreUpdateListener.Severity.ERROR, e);
                continue;
            }
            String crlHash = OpensslTrustAnchorStore.getOpenSSLCAHash(crl.getIssuerX500Principal());
            if (!fileHash.equalsIgnoreCase(crlHash)) {
                this.notifyObservers(location.toExternalForm(), StoreUpdateListener.Severity.WARNING, new Exception("The CRL won't be used as its name has incorrect issuers's hash value. Should be " + crlHash + " but is " + fileHash));
                continue;
            }
            this.notifyObservers(location.toExternalForm(), StoreUpdateListener.Severity.NOTIFICATION, null);
            this.addCRL(crl, location);
        }
    }
}

