/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.client;

import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xfire.WSRFClientFactory;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceLifetime;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperties;
import de.fzj.unicore.wsrflite.xmlbeans.WSResource;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.InvalidResourcePropertyQNameFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.TerminationTimeChangeRejectedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.UnableToSetTerminationTimeFault;
import eu.unicore.security.OperationType;
import eu.unicore.security.xfireutil.client.ReliableProxy;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.ETDClientSettings;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.rl2.CurrentTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.DestroyDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rp2.GetMultipleResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.GetMultipleResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentDocument1;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.QueryExpressionType;
import org.oasisOpen.docs.wsrf.rp2.QueryResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.QueryResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateType;
import org.unigrids.services.atomic.types.AllowedAccessTypesType;
import org.unigrids.services.atomic.types.VOMembershipType;
import org.unigrids.services.atomic.types.VOMembershipsDocument;
import org.unigrids.services.atomic.types.VOMembershipsType;
import org.unigrids.services.atomic.types.VOWithRegistriesType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class BaseWSRFClient {
    protected static final Logger logger = Log.getLogger("unicore.client", BaseWSRFClient.class);
    protected final EndpointReferenceType epr;
    protected final String url;
    protected final WSRFClientFactory proxyMaker;
    protected final ResourceLifetime lt;
    protected final ResourceProperties rp;
    private GetResourcePropertyDocumentResponseDocument resourcePropertyDocument;
    private long updateInterval = 500L;
    private long lastAccessed;
    protected ReliableProxy.RetryDecider retryDecider;

    public BaseWSRFClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public BaseWSRFClient(String endpointUrl, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        ETDClientSettings etd;
        this.epr = epr;
        this.url = endpointUrl;
        if (sec != null && (etd = sec.getETDSettings()) != null && etd.isExtendTrustDelegation()) {
            sec = sec.clone();
            BaseWSRFClient.setReceiver(epr, sec);
        }
        this.proxyMaker = new WSRFClientFactory(sec);
        this.lt = this.makeProxy(ResourceLifetime.class);
        this.rp = this.makeProxy(ResourceProperties.class);
    }

    private static void setReceiver(EndpointReferenceType epr, IClientConfiguration sec) {
        X500Principal p = WSUtilities.extractServerX500Principal(epr);
        if (p != null) {
            sec.getETDSettings().setReceiver(p);
        }
    }

    public BaseWSRFClient(String endpointUrl, EndpointReferenceType epr, WSRFClientFactory clientFactory) throws Exception {
        this.epr = epr;
        this.url = endpointUrl;
        this.proxyMaker = clientFactory;
        this.lt = this.makeProxy(ResourceLifetime.class);
        this.rp = this.makeProxy(ResourceProperties.class);
    }

    public final String getFriendlyName() {
        return WSUtilities.extractFriendlyNameFromEPR(this.epr);
    }

    public final EndpointReferenceType getEPR() {
        return this.epr;
    }

    public final String getUrl() {
        return this.url;
    }

    public final IClientConfiguration getSecurityConfiguration() {
        return this.proxyMaker.getSecurityConfiguration();
    }

    public <T> T makeProxy(Class<T> iFace) throws Exception {
        if (!iFace.isInterface()) {
            throw new IllegalArgumentException("Can only create proxy from an interface.");
        }
        T proxy = this.proxyMaker.createProxy(iFace, this.url, this.epr);
        this.configureRetry(proxy);
        return proxy;
    }

    public String getResourceProperty(QName rpQname) throws BaseFault, InvalidResourcePropertyQNameFault, ResourceUnavailableFault, ResourceUnknownFault, ClientException {
        logger.debug("Calling service at wsaTo: " + this.epr.getAddress().getStringValue());
        GetResourcePropertyDocument req = GetResourcePropertyDocument.Factory.newInstance();
        req.setGetResourceProperty(rpQname);
        GetResourcePropertyResponseDocument res = this.rp.GetResourceProperty(req);
        return res.getGetResourcePropertyResponse().toString();
    }

    public void destroy() throws BaseFault, ResourceUnavailableFault, ResourceUnknownFault, ResourceNotDestroyedFault, ClientException {
        logger.debug("Calling service at wsaTo: " + this.epr.getAddress().getStringValue());
        DestroyDocument dd = DestroyDocument.Factory.newInstance();
        dd.addNewDestroy();
        this.lt.Destroy(dd);
        this.resourcePropertyDocument = null;
    }

    public Calendar setTerminationTime(Calendar newTerminationTime) throws BaseFault, UnableToSetTerminationTimeFault, TerminationTimeChangeRejectedFault, ResourceUnavailableFault, ResourceUnknownFault, ClientException {
        logger.debug("Calling service at wsaTo: " + this.epr.getAddress().getStringValue());
        SetTerminationTimeDocument req = SetTerminationTimeDocument.Factory.newInstance();
        req.addNewSetTerminationTime().setRequestedTerminationTime(newTerminationTime);
        return this.lt.SetTerminationTime(req).getSetTerminationTimeResponse().getNewTerminationTime();
    }

    public Calendar getTerminationTime() throws BaseFault, InvalidResourcePropertyQNameFault, ResourceUnavailableFault, ResourceUnknownFault, ClientException {
        GetResourcePropertyDocument req = GetResourcePropertyDocument.Factory.newInstance();
        req.setGetResourceProperty(WSResource.RPterminationTimeQName);
        GetResourcePropertyResponseDocument res = this.rp.GetResourceProperty(req);
        try {
            TerminationTimeDocument o = TerminationTimeDocument.Factory.parse(WSUtilities.extractResourceProperty(res).newInputStream());
            if (o == null) {
                return null;
            }
            if (o.getTerminationTime().isNil()) {
                return null;
            }
            return o.getTerminationTime().getCalendarValue();
        }
        catch (IOException ioe) {
            throw new ClientException("Could not parse reply from server.", ioe);
        }
        catch (XmlException ioe) {
            throw new ClientException("Could not parse reply from server.", ioe);
        }
    }

    public Calendar getCurrentTime() throws BaseFault, ResourceUnavailableFault, ResourceUnknownFault, ClientException {
        GetResourcePropertyDocument req = GetResourcePropertyDocument.Factory.newInstance();
        req.setGetResourceProperty(WSResource.RPcurrentTimeQName);
        GetResourcePropertyResponseDocument res = this.rp.GetResourceProperty(req);
        try {
            CurrentTimeDocument o = CurrentTimeDocument.Factory.parse(WSUtilities.extractResourceProperty(res).newInputStream());
            return o.getCurrentTime().getCalendarValue();
        }
        catch (IOException ioe) {
            throw new ClientException("Could not parse reply from server.", ioe);
        }
        catch (XmlException ioe) {
            throw new ClientException("Could not parse reply from server.", ioe);
        }
    }

    public String getResourcePropertyDocument() throws BaseFault, ResourceUnknownFault, ResourceUnavailableFault, ClientException {
        GetResourcePropertyDocumentResponseDocument resp = this.GetResourcePropertyDocument();
        if (resp == null) {
            throw new ClientException("Server <" + this.getEPR().getAddress().getStringValue() + "> returned <null>");
        }
        return String.valueOf(resp);
    }

    public GetResourcePropertyDocumentResponseDocument GetResourcePropertyDocument() throws BaseFault, ResourceUnknownFault, ResourceUnavailableFault, ClientException {
        if (this.resourcePropertyDocument == null || System.currentTimeMillis() - this.lastAccessed > this.updateInterval) {
            logger.debug("Calling service at wsaTo: " + this.epr.getAddress().getStringValue());
            GetResourcePropertyDocumentDocument1 req = GetResourcePropertyDocumentDocument1.Factory.newInstance();
            req.addNewGetResourcePropertyDocument();
            this.resourcePropertyDocument = this.rp.GetResourcePropertyDocument(req);
            this.lastAccessed = System.currentTimeMillis();
        }
        return this.resourcePropertyDocument;
    }

    public QueryResourcePropertiesResponseDocument queryResourceProperties(String xpath) throws BaseFault, ResourceUnknownFault, ResourceUnavailableFault, ClientException {
        QueryResourcePropertiesDocument req = QueryResourcePropertiesDocument.Factory.newInstance();
        QueryExpressionType q = QueryExpressionType.Factory.newInstance();
        q.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
        q.newCursor().setTextValue(xpath);
        req.addNewQueryResourceProperties().setQueryExpression(q);
        return this.rp.QueryResourceProperties(req);
    }

    public Map<QName, XmlObject[]> getMultipleResourceProperties(QName ... names) throws BaseFault, ResourceUnknownFault, ResourceUnavailableFault, ClientException {
        if (names == null || names.length == 0) {
            throw new IllegalArgumentException("No QNames given.");
        }
        GetMultipleResourcePropertiesDocument in = GetMultipleResourcePropertiesDocument.Factory.newInstance();
        in.addNewGetMultipleResourceProperties();
        for (QName q : names) {
            in.getGetMultipleResourceProperties().addNewResourceProperty().setQNameValue(q);
        }
        GetMultipleResourcePropertiesResponseDocument res = this.rp.GetMultipleResourceProperties(in);
        HashMap<QName, XmlObject[]> result = new HashMap<QName, XmlObject[]>();
        GetMultipleResourcePropertiesResponseDocument.GetMultipleResourcePropertiesResponse response = res.getGetMultipleResourcePropertiesResponse();
        for (QName q : names) {
            try {
                result.put(q, WSUtilities.extractAnyElements(response, q));
            }
            catch (Exception e) {
                logger.warn("Can't extract result for property " + q);
            }
        }
        return result;
    }

    public void setRetryHandler(ReliableProxy.RetryDecider retry) {
        this.retryDecider = retry;
        Class<?> c = this.getClass();
        while (c.getSuperclass() != null) {
            for (Field f : c.getDeclaredFields()) {
                try {
                    f.setAccessible(true);
                    Object obj = f.get(this);
                    if (obj == null || !Proxy.isProxyClass(obj.getClass())) continue;
                    this.configureRetry(obj);
                }
                catch (Exception ex) {
                    Log.logException("Can't reconfigure retry on <" + f.getName() + ">", ex, logger);
                }
            }
            c = c.getSuperclass();
        }
    }

    protected void configureRetry(Object proxy) {
        ReliableProxy xp = (ReliableProxy)Proxy.getInvocationHandler(proxy);
        xp.setRetryDecider(this.retryDecider);
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(long updateInterval) {
        this.updateInterval = updateInterval;
    }

    public String getConnectionStatus() throws ClientException {
        if (this.checkConnection()) {
            return "OK";
        }
        return "Can't connect.";
    }

    public boolean checkConnection() throws ClientException {
        return this.checkConnection(-1);
    }

    public boolean checkConnection(int timeout) throws ClientException {
        try {
            if (timeout > 0) {
                IClientConfiguration p = this.getSecurityConfiguration().clone();
                p.getExtraSettings().put("http.connection.timeout", String.valueOf(timeout));
                new BaseWSRFClient(this.getUrl(), this.getEPR(), p).getCurrentTime();
            } else {
                this.getCurrentTime();
            }
            return true;
        }
        catch (ClientException ce) {
            throw ce;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void shareWithVO(String vo, EndpointReferenceType voRegistry, OperationType[] shareMode) throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault, ClientException, XmlException {
        VOMembershipsDocument newRpDoc = VOMembershipsDocument.Factory.newInstance();
        VOMembershipsType newRp = newRpDoc.addNewVOMemberships();
        AllowedAccessTypesType allowedAccess = AllowedAccessTypesType.Factory.newInstance();
        for (OperationType opType : shareMode) {
            allowedAccess.addAllowedAccessType(opType.toString());
        }
        VOMembershipType[] arr = this.getVOSharingRP();
        boolean modified = false;
        for (VOMembershipType xml : arr) {
            if (xml.getVo().getVoName().equals(vo)) {
                modified = true;
                xml.setAllowedAccessTypes(allowedAccess);
            }
            newRp.addNewMembership().set(xml);
        }
        if (!modified) {
            VOMembershipType addedMem = newRp.addNewMembership();
            addedMem.setAllowedAccessTypes(allowedAccess);
            VOWithRegistriesType voExt = addedMem.addNewVo();
            voExt.setVoName(vo);
            if (voRegistry != null) {
                voExt.setVoRegistry(voRegistry);
            }
        }
        this.updateVORP(newRpDoc);
    }

    public void unshareWithVO(String vo) throws InvalidResourcePropertyQNameFault, BaseFault, ResourceUnavailableFault, ResourceUnknownFault, ClientException, XmlException {
        VOMembershipsDocument newRpDoc = VOMembershipsDocument.Factory.newInstance();
        VOMembershipsType newRp = newRpDoc.addNewVOMemberships();
        VOMembershipType[] arr = this.getVOSharingRP();
        boolean removed = false;
        for (VOMembershipType xml : arr) {
            if (xml.getVo().getVoName().equals(vo)) {
                removed = true;
                continue;
            }
            newRp.addNewMembership().set(xml);
        }
        if (removed) {
            this.updateVORP(newRpDoc);
        }
    }

    public Map<String, Set<OperationType>> getSharing() throws InvalidResourcePropertyQNameFault, BaseFault, ResourceUnavailableFault, ResourceUnknownFault, ClientException, XmlException {
        VOMembershipType[] arr = this.getVOSharingRP();
        HashMap<String, Set<OperationType>> ret = new HashMap<String, Set<OperationType>>();
        for (VOMembershipType xml : arr) {
            String[] allowedTypes;
            HashSet<OperationType> modes = new HashSet<OperationType>();
            for (String allowed : allowedTypes = xml.getAllowedAccessTypes().getAllowedAccessTypeArray()) {
                modes.add(OperationType.valueOf(allowed));
            }
            ret.put(xml.getVo().getVoName(), modes);
        }
        return ret;
    }

    protected VOMembershipType[] getVOSharingRP() throws InvalidResourcePropertyQNameFault, BaseFault, ResourceUnavailableFault, ResourceUnknownFault, ClientException, XmlException {
        QName rpName = new QName("http://unigrids.org/2006/04/types", "VOMemberships");
        GetResourcePropertyDocument req = GetResourcePropertyDocument.Factory.newInstance();
        req.setGetResourceProperty(rpName);
        GetResourcePropertyResponseDocument res = this.rp.GetResourceProperty(req);
        try {
            VOMembershipsDocument rpDoc = VOMembershipsDocument.Factory.parse(res.getGetResourcePropertyResponse().newReader());
            return rpDoc.getVOMemberships().getMembershipArray();
        }
        catch (Exception e) {
            return new VOMembershipType[0];
        }
    }

    protected void updateVORP(VOMembershipsDocument newRpDoc) throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
        UpdateResourcePropertiesDocument reqDoc = UpdateResourcePropertiesDocument.Factory.newInstance();
        UpdateResourcePropertiesDocument.UpdateResourceProperties req = reqDoc.addNewUpdateResourceProperties();
        UpdateType update = req.addNewUpdate();
        update.set(newRpDoc);
        this.rp.UpdateResourceProperties(reqDoc);
    }

    public ResourceProperties getRP() {
        return this.rp;
    }

    public ResourceLifetime getLT() {
        return this.lt;
    }
}

