/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.InvalidResourcePropertyQNameFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import eu.unicore.security.xfireutil.client.ReliableProxy;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.lang.reflect.Method;
import org.codehaus.xfire.XFireRuntimeException;
import org.unigrids.services.atomic.types.SecurityDocument;
import org.unigrids.services.atomic.types.SecurityType;
import org.unigrids.services.atomic.types.VOType;
import org.unigrids.services.atomic.types.VersionDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class BaseUASClient
extends BaseWSRFClient {
    public BaseUASClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
        this.setRetryDefaults();
    }

    public BaseUASClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(epr.getAddress().getStringValue(), epr, sec);
        this.setRetryDefaults();
    }

    protected void setRetryDefaults() {
        ReliableProxy.RetryDecider rd = new ReliableProxy.RetryDecider(){

            @Override
            public boolean retry(Method m, Throwable error, int numberOfUnsuccessfulTries) {
                String msg = Log.createFaultMessage("", error);
                if (error instanceof ResourceUnavailableFault || msg.contains("Resource unavailable")) {
                    if (numberOfUnsuccessfulTries > 2) {
                        return false;
                    }
                    int n = (numberOfUnsuccessfulTries + 1) * 30;
                    logger.info("Resource <" + BaseUASClient.this.getUrl() + "> is unavailable. Will retry in " + n + " seconds");
                    try {
                        Thread.sleep(n * 1000);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    return true;
                }
                if (error instanceof BaseFault) {
                    return false;
                }
                if (error instanceof XFireRuntimeException) {
                    XFireRuntimeException xfre = (XFireRuntimeException)error;
                    try {
                        String message = xfre.getCause().getMessage().toLowerCase();
                        if (message.contains("access denied")) {
                            return false;
                        }
                        if (message.contains("connection refused")) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return numberOfUnsuccessfulTries > 2;
            }
        };
        this.setRetryHandler(rd);
    }

    public String getServerVersion() throws Exception {
        try {
            String verRP = this.getResourceProperty(VersionDocument.type.getDocumentElementName());
            if (verRP != null) {
                VersionDocument vD = VersionDocument.Factory.parse(verRP);
                return vD.getVersion();
            }
        }
        catch (InvalidResourcePropertyQNameFault invalidResourcePropertyQNameFault) {
            // empty catch block
        }
        return null;
    }

    public SecurityType getSecurityInfo() throws Exception {
        SecurityDocument sd = SecurityDocument.Factory.parse(this.getResourceProperty(SecurityDocument.type.getDocumentElementName()));
        return sd != null ? sd.getSecurity() : SecurityType.Factory.newInstance();
    }

    public String[] getXlogins() throws Exception {
        String[] srs = new String[]{};
        SecurityType secT = this.getSecurityInfo();
        if (secT != null && secT.getClientValidXlogins() != null) {
            srs = secT.getClientValidXlogins().getXloginArray();
        }
        return srs;
    }

    public String[] getXgroups() throws Exception {
        String[] srs = new String[]{};
        SecurityType secT = this.getSecurityInfo();
        if (secT != null && secT.getClientValidXgroups() != null) {
            srs = secT.getClientValidXgroups().getXgroupArray();
        }
        return srs;
    }

    public String[] getAcceptedCAs() throws Exception {
        String[] srs = new String[]{};
        SecurityType secT = this.getSecurityInfo();
        if (secT != null) {
            if (secT.getAcceptedCAs() != null) {
                srs = secT.getAcceptedCAs().getAcceptedCAArray();
            } else if (secT.getTrustedCAArray() != null) {
                return secT.getTrustedCAArray();
            }
        }
        return srs;
    }

    public VOType[] getAcceptedVOs() throws Exception {
        VOType[] srs = new VOType[]{};
        SecurityType secT = this.getSecurityInfo();
        if (secT != null && secT.getAcceptedVOs() != null) {
            srs = secT.getAcceptedVOs().getVOArray();
        }
        return srs;
    }

    public synchronized boolean checkVersion(String required) throws Exception {
        String v = this.getServerVersion();
        return BaseUASClient.compareVersions(required, v);
    }

    static boolean compareVersions(String required, String actual) {
        return required.compareTo(actual) <= 0 || "DEVELOPMENT".equalsIgnoreCase(actual);
    }
}

