#!/bin/bash

#
# Startup script for UNICORE/X
#

#
# Read basic configuration parameters
#
. /etc/unicore/unicorex/startup.properties


#
# check whether the server might be already running
#
if [ -e $PID ] 
 then 
  if [ -d /proc/$(cat $PID) ]
   then
     echo "A UNICORE/X instance may be already running with process id "$(cat $PID)
     echo "If this is not the case, delete the file $PID and re-run this script"
     exit 1
   fi
fi

#
# setup classpath
#
CP=.$(cd / ; find "$LIB" -name "*.jar" -exec printf ":{}" \;)

PARAM=$*
if [ "$PARAM" = "" ]
then
  PARAM=${CONF}/uas.config
fi

#
# go
#

CLASSPATH=$CP ; export CLASSPATH

nohup $JAVA ${MEM} ${OPTS} ${DEFS} de.fzj.unicore.uas.UAS ${PARAM} UNICOREX > $STARTLOG 2>&1  & echo $! > $PID

echo "UNICORE/X starting"

