package de.fzj.unicore.uas.xtreemfs;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.net.URI;
import java.util.Arrays;

import javax.security.auth.x500.X500Principal;

import org.apache.commons.io.FileUtils;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.TestConfigUtil;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.XNJS;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ActionStatus;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IFileTransfer.OverwritePolicy;
import de.fzj.unicore.xnjs.io.IFileTransferEngine;
import eu.unicore.security.Client;
import eu.unicore.security.SecurityTokens;

public class TestXtreemFSFileTransfer {

	private static XNJS xnjs;
	private static Configuration config;
	
	@BeforeClass
	public static void setupXNJS()throws Exception{
		FileUtils.deleteQuietly(new File("target","data"));
		FileUtils.deleteQuietly(new File("target","xnjs_data"));
		xnjs=new XNJS("src/test/resources/xnjs.xml");
		xnjs.start();
		config=xnjs.getConfig();
		Kernel k=new Kernel(TestConfigUtil.getInsecureProperties());
		config.registerComponent(k);
	}
	
	@AfterClass
	public static void shutdownXNJS()throws Exception{
		xnjs.stop();
		FileUtils.deleteQuietly(new File("target","data"));
		FileUtils.deleteQuietly(new File("target","xnjs_data"));
	}
	
	@Test
	public void testCreatorRegistration(){
		IFileTransferEngine sf=xnjs.getConfig().getComponentInstanceOfType(IFileTransferEngine.class);
		String[]p=sf.listProtocols();
		assertTrue(Arrays.asList(p).contains("xtreemfs"));
	}
	
	@Test
	public void testCreateExport()throws Exception{
		IFileTransferEngine sf=xnjs.getConfig().getComponentInstanceOfType(IFileTransferEngine.class);
		Client client=makeClient();
		String source="test";
		String wd="target";
		URI target=new URI("xtreemfs://CN=Test,C=DE/test.txt");
		OverwritePolicy overwrite=OverwritePolicy.OVERWRITE;
		IFileTransfer ft=sf.createFileExport(client, wd, source, target, overwrite,null);
		assertNotNull(ft);
	}
	
	@Test
	public void testStageOut()throws Exception{
		String targetDir=new File("target").getAbsolutePath();
		config.setProperty(Constants.XTREEMFS_LOCAL_MOUNT, targetDir);
		
		JobDefinitionDocument job=JobDefinitionDocument.Factory.newInstance();
		job.addNewJobDefinition().addNewJobDescription().addNewApplication().setApplicationName("Date");
		DataStagingType dst=job.getJobDefinition().getJobDescription().addNewDataStaging();
		dst.setFileName("stdout");
		String path="CN=test/test123";
		dst.addNewTarget().setURI("xtreemfs://"+path);
		Action a=xnjs.getConfig().makeAction(job);
		a.getProcessingContext().put(Action.AUTO_SUBMIT,Boolean.TRUE);
		Client client=makeClient();
		xnjs.getConfig().getEMSManager().add(a, client);
		waitForFinished(a.getUUID(), client);
		a=xnjs.getConfig().getInternalManager().getAction(a.getUUID());
		assertTrue(a.getResult().isSuccessful());
		//check that file was exported
		File exported=new File(targetDir,path);
		assertTrue(exported.exists());
	}

	@Test
	public void testStageIn()throws Exception{
		String sourceDir=new File("src/test/resources").getAbsolutePath();
		config.setProperty(Constants.XTREEMFS_LOCAL_MOUNT, sourceDir);
		JobDefinitionDocument job=JobDefinitionDocument.Factory.newInstance();
		job.addNewJobDefinition().addNewJobDescription().addNewApplication().setApplicationName("Date");
		DataStagingType dst=job.getJobDefinition().getJobDescription().addNewDataStaging();
		dst.setFileName("infile");
		String path="simpleidb";
		dst.addNewSource().setURI("xtreemfs://"+path);
		Action a=config.makeAction(job);
		a.getProcessingContext().put(Action.AUTO_SUBMIT,Boolean.TRUE);
		Client client=makeClient();
		config.getEMSManager().add(a, client);
		waitForFinished(a.getUUID(), client);
		a=config.getInternalManager().getAction(a.getUUID());
		assertTrue(a.getResult().isSuccessful());
		//check that file was exported
		File imported=new File(a.getExecutionContext().getWorkingDirectory()+"infile");
		assertTrue(imported.exists());
	}
	
	protected void waitForFinished(String id, Client client)throws Exception{
		int i=0;
		while(i<10){
			if(ActionStatus.DONE==xnjs.getConfig().getEMSManager().getStatus(id, client)){
				break;
			}
			else{
				Thread.sleep(1000);
				i++;
			}
		}
	}
	
	private Client makeClient(){
		Client client=new Client();
		SecurityTokens t=new SecurityTokens();
		t.setUserName(new X500Principal("CN=test"));
		client.setAuthenticatedClient(t);
		return client;
	}
	
}
