package de.fzj.unicore.uas.xtreemfs;

import java.io.InputStream;
import java.net.URI;

import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.ProtocolType;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;
import eu.unicore.util.Log;

/**
 * upload data to XtreemFS
 * 
 * @author schuller
 */
public class XtreemFSUpload extends XtreemFSTransferBase{
	
	private static final Logger logger=Log.getLogger(Log.SERVICES, XtreemFSUpload.class);
	
	private final String workdir;
	private final String source;
	private final URI target;
	
	public XtreemFSUpload(Configuration configuration, Client client, String workdir, String source, URI target){
		super(configuration,client);
		this.workdir=workdir;
		this.source=source;
		this.target=target;
	}

	@Override
	public long getDataSize() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public String getSource() {
		return source;
	}
	
	@Override
	public String getTarget() {
		return target.toString();
	}

	@Override
	public long getTransferredBytes() {
		return 0;
	}

	@Override
	public void run() {
		status=Status.RUNNING;
		try{
			String baseDir=configuration.getProperty(XTREEMFS_LOCAL_MOUNT);
			if(baseDir==null){
				baseDir=xtreemProperties.getValue(XtreemProperties.XTREEMFS_LOCAL_MOUNT);
			}
			if(baseDir!=null){
				exportLocally(baseDir);
			}
			else{
				uploadToRemoteSMS();
			}
			status=Status.DONE;
		}catch(Exception ex){
			status=Status.FAILED;
			statusMessage=Log.createFaultMessage("File export failed.", ex);
		}
	}

	protected void exportLocally(String baseDir)throws Exception{
		if(baseDir==null)throw new IllegalStateException("No local XtreemFS mountpoint defined.");
		String realTarget=baseDir+SMSBaseImpl.urlDecode(makeTarget());
		String realSource=workdir+"/"+source;
		ensureDirectoriesExist(realTarget);
		//just copy file to remote ...
		TSI tsi=configuration.getTargetSystemInterface(client);
		tsi.cp(realSource, realTarget);
		logger.info("Copied: "+realSource+" to "+realTarget);
	}
	
	String makeTarget(){
		return target.getRawSchemeSpecificPart();
	}


	protected void uploadToRemoteSMS()throws Exception{
		StorageClient sms=createStorageClient();
		logger.info("Uploading to remote SMS "+sms.getUrl());
		FileTransferClient ftc=sms.getImport(makeTarget(), ProtocolType.BFT);
		TSI tsi=configuration.getStorageTSI(workdir, client);
		InputStream is=tsi.getInputStream(source);
		try{
			ftc.writeAllData(is);
		}
		finally{
			try{
				ftc.destroy();
			}catch(Exception ex){}
			try{
				is.close();
			}catch(Exception ex){}
		}
	}
	
}
