package de.fzj.unicore.uas.xtreemfs;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;

import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.ETDAssertionForwarding;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.OptionNotSupportedException;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;
import eu.unicore.util.httpclient.IClientConfiguration;

public abstract class XtreemFSTransferBase implements IFileTransfer, Constants{
	
	protected Status status;
	protected String statusMessage="OK.";
	
	protected final Configuration configuration;
	protected final Client client;
	protected final String uuid;
	protected OverwritePolicy overwrite;
	private String parentActionID;
	protected volatile boolean aborted=false;
	protected boolean ignoreFailure;
	protected final Kernel kernel;
	protected final XtreemProperties xtreemProperties;
	
	public XtreemFSTransferBase(Configuration configuration, Client client){
		this.configuration=configuration;
		this.client=client;
		this.uuid=UUID.randomUUID().toString();
		status=Status.CREATED;
		this.kernel=configuration.getComponentInstanceOfType(Kernel.class);
		xtreemProperties = kernel.getAttribute(XtreemProperties.class);
	}
	
	public boolean abort(){
		aborted=true;
		return true;
	}
	
	@Override
	public String getParentActionID() {
		return parentActionID;
	}

	@Override
	public Status getStatus() {
		return status;
	}

	@Override
	public String getStatusMessage() {
		return statusMessage;
	}

	@Override
	public String getUniqueId() {
		return uuid;
	}

	@Override
	public boolean isStreaming() {
		return false;
	}

	@Override
	public Map<String, Serializable> pause() {
		//Not supported...
		return null;
	}

	@Override
	public void resume(Map<String, Serializable> status) {
		//Not supported... 
	}

	protected void ensureDirectoriesExist(String path)throws Exception{
		String dir=path.substring(0,path.lastIndexOf("/"));
		TSI tsi=configuration.getTargetSystemInterface(client);
		tsi.mkdir(dir);
	}
	
	protected StorageClient createStorageClient()throws Exception{
		IClientConfiguration sec=kernel.getClientConfiguration().clone();
		ETDAssertionForwarding.configureETD(client, sec);
		String address=xtreemProperties.getValue(XtreemProperties.XTREEMFS_REMOTE_URL);
		if(address==null){
			//TODO check for an XtreemFS SMS in the external registry
			throw new IllegalStateException("No SMS for remote XtreemFS access is defined!");
		}
		EndpointReferenceType epr=EndpointReferenceType.Factory.newInstance();
		epr.addNewAddress().setStringValue(address);
		StorageClient sms=new StorageClient(epr,sec);
		return sms;
	}
	
	@Override
	public void setOverwritePolicy(OverwritePolicy overwrite)
			throws OptionNotSupportedException {
		this.overwrite=overwrite;
	}

	@Override
	public void setParentActionID(String actionID) {
		this.parentActionID=actionID;
	}

	@Override
	public void setStorageAdapter(IStorageAdapter adapter) {

	}
	
	@Override
	public String getProtocol() {
		return "xtreemfs";
	}
	
	public void setIgnoreFailure(boolean ignoreFailure){
		this.ignoreFailure=ignoreFailure;
	}
	
	public boolean isIgnoreFailure(){
		return ignoreFailure;
	}
}
