package de.fzj.unicore.uas.xtreemfs;

import java.net.URI;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IFileTransferCreator;
import eu.unicore.security.Client;

public class XtreemFSFileTransferCreator implements IFileTransferCreator {

	private final Configuration configuration;
	
	public XtreemFSFileTransferCreator(Configuration configuration){
		this.configuration=configuration;
	}
	
	@Override
	public IFileTransfer createFileExport(Client client, String workdir, String source,
			URI target, DataStagingCredentials creds) {
		if("xtreemfs".equalsIgnoreCase(target.getScheme())){
			return new XtreemFSUpload(configuration,client,workdir,source,target);
		}
		return null;
	}

	@Override
	public IFileTransfer createFileImport(Client client, String workdir, URI source,
			String target, DataStagingCredentials creds) {
		if("xtreemfs".equalsIgnoreCase(source.getScheme())){
			return new XtreemFSDownload(configuration,client,workdir,source,target);
		}
		return null;
	}

	@Override
	public String getProtocol() {
		return "xtreemfs";
	}

}
