package de.fzj.unicore.uas.fts.uftp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import org.unigrids.services.atomic.types.ProtocolType;

import de.fzj.unicore.uas.client.UFTPConstants;
import de.fzj.unicore.uas.client.UFTPFileTransferClient;
import de.fzj.unicore.uas.xnjs.U6FileImportBase;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.util.AsyncCommandHelper;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.fzj.unicore.xnjs.util.ResultHolder;
import eu.unicore.util.Log;
import eu.unicore.uftp.client.UFTPClient;

public class UFTPImport extends U6FileImportBase implements UFTPConstants{

	private String secret;

	/** whether the Java UFTP library should be used directly, which requires that
	 * the UNICORE/X has access to the file system<br/>
	 * If set to <code>false</code>, the TSI is used to run the UFTP client   
	 */
	private final boolean localMode;

	private final boolean useEncryption;

	private final UFTPProperties uftpProperties;
	
	public UFTPImport(Configuration config){
		super(config);
		uftpProperties = kernel.getAttribute(UFTPProperties.class);
		localMode = uftpProperties.getBooleanValue(UFTPProperties.PARAM_CLIENT_LOCAL);
		//TODO this should be specified by the user, not globally. If fixed, then remove the config option.
		useEncryption=uftpProperties.getBooleanValue(UFTPProperties.PARAM_ENABLE_ENCRYPTION);
	}

	@Override
	public long getTransferredBytes() {
		if(localMode){
			return super.getTransferredBytes();
		}
		else{
			try{
				XnjsFile x=configuration.getTargetSystemInterface(client).getProperties(localFile);
				if(x!=null){
					transferredBytes=x.getSize();//TODO what about appending to an existing file
				}
			}
			catch(Exception ex){
				Log.logException("Can't get size of local file", ex, logger);
			}
			return transferredBytes;
		}
	}

	@Override
	public String getProtocol() {
		return ProtocolType.UFTP.toString();
	}

	@Override
	protected UFTPFileTransferClient getFTClient() throws Exception {
		String url=fileTransferInstanceEpr.getAddress().getStringValue();
		UFTPFileTransferClient c=new UFTPFileTransferClient(url, fileTransferInstanceEpr, sec);
		c.setSecret(secret);
		return c;
	}

	protected Map<String,String>getExtraParameters(){
		Map<String,String>result=new HashMap<String, String>();
		String clientHost=getClientHost();
		result.put(PARAM_CLIENT_HOST, clientHost);
		result.put(PARAM_STREAMS,getNumberOfStreams());
		secret=UUID.randomUUID().toString();
		result.put(PARAM_SECRET, secret);
		result.put(PARAM_ENABLE_ENCRYPTION,String.valueOf(useEncryption));
		return result;
	}

	@Override
	protected void doRun() throws Exception {
		if(localMode){
			super.doRun();
		}
		else{
			runAsync();
		}
	}

	protected String getClientHost(){
		String clientHost=uftpProperties.getValue(UFTPProperties.PARAM_CLIENT_HOST);
		if(clientHost==null){
			if(localMode){
				try{
					clientHost=InetAddress.getLocalHost().getCanonicalHostName();
				}catch(Exception ex){
					clientHost="localhost";
				}
			}
			else{
				//server host should be OK in non-local mode
				clientHost=uftpProperties.getValue(UFTPProperties.PARAM_SERVER_HOST);
			}
		}
		return clientHost;
	}

	protected String getNumberOfStreams(){
		return uftpProperties.getValue(UFTPProperties.PARAM_STREAMS);
	}

	private AsyncCommandHelper ach;

	protected void runAsync()throws Exception{
		String cmd=getCommandLine();
		ach=new AsyncCommandHelper(configuration, cmd, uuid, getParentActionID(), client);
		ach.submit();
		while(!ach.isDone()){
			Thread.sleep(500);
		}
		ResultHolder res=ach.getResult();
		if(res.getExitCode()==null || res.getExitCode()!=0){
			String message="UFTP upload failed.";
			try{
				String error=res.getStdErr();
				if(error!=null)message+=" Error details: "+error;
			}catch(IOException ex){
				LogUtil.logException("Could not read UFTP stderr",ex,logger);
			}
			throw new Exception(message);
		}
	}

	private String getCommandLine()throws Exception{
		String uftp = uftpProperties.getValue(UFTPProperties.PARAM_CLIENT_EXECUTABLE);
		UFTPFileTransferClient client=getFTClient();
		String host=client.asString(client.getServerHosts());
		int port=client.getServerPort();
		int streams=client.getStreams();
		String key=client.getEncryptionKey();
		boolean append=OverwritePolicy.APPEND.equals(this.overwrite);
		String file=workdir+"/"+localFile;
		int buf = uftpProperties.getIntValue(UFTPProperties.PARAM_BUFFERSIZE);
		return uftp+" "+UFTPClient.makeCommandline(host, port, file, false, secret, streams, key, append, buf);
	}
}
