package de.fzj.unicore.uas.fts.uftp;

import de.fzj.unicore.uas.fts.FileTransferCapability;
import de.fzj.unicore.uas.fts.FileTransferImpl;
import de.fzj.unicore.uas.xnjs.U6FileTransferBase;
import de.fzj.unicore.wsrflite.Capabilities;
import de.fzj.unicore.wsrflite.Capability;

/**
 * for advertising the UFTP server capabilities to the UNICORE/X container
 * 
 * @author schuller
 */
public class UFTPCapabilities implements Capabilities{

	@Override
	public Capability[] getCapabilities() {
		return new Capability[]{
				UFTPCapability
		};
	}

	private static Capability UFTPCapability = new FileTransferCapability(){

		@Override
		public String getProtocol() {
			return "UFTP";
		}

		@Override
		public Class<?> getImplementation() {
			return UFTPFileTransferImpl.class;
		}

		@Override
		public Class<?> getInterface() {
			return FileTransferImpl.class;
		}
		
		@Override
		public Class<? extends U6FileTransferBase> getExporter() {
			return UFTPExport.class;
		}

		@Override
		public Class<? extends U6FileTransferBase> getImporter() {
			return UFTPImport.class;
		}
	};

}
