package de.fzj.unicore.uas.irods;

import org.apache.commons.io.FileUtils;
import java.io.File;
import de.fzj.unicore.uas.client.FileTransferClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemType;
import org.unigrids.services.atomic.types.ProtocolType;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.wsrflite.ContainerProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.unigrids.services.atomic.types.GridFileType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import static org.junit.Assert.*;

/**
 *
 * @author jrybicki
 */
public class SMSIRodsImplTest {

    static StorageClient sc;
    static String configPath = "src/test/resources/uas.config";
    private static String url;

    public SMSIRodsImplTest() {
    }
    private final static String testDir = "/testDir";

    @BeforeClass
    public static void setUpClass() throws Exception {
        long start = System.currentTimeMillis();
        System.out.println("Starting UNICORE/X ...");

        FileUtils.deleteQuietly(new File("target", "data"));

        //setup UAS
        UAS uas = new UAS(configPath);
        uas.startSynchronous();
        Kernel kernel = uas.getKernel();
        System.err.println("Startup time: " + (System.currentTimeMillis() - start) + " ms.");
        // create a "default" TSS - Target System Service
        Home h = kernel.getHome(UAS.TSS);
        Map<String, Object> initObj = new HashMap<String, Object>();
        initObj.put(UASWSResourceImpl.INIT_UNIQUE_ID, "default_targetsystem");
        h.createWSRFServiceInstance(initObj);

        url = kernel.getContainerProperties().getValue(ContainerProperties.WSRF_BASEURL);
        System.out.println("Creating StorageClient");
        EndpointReferenceType smsEpr = EndpointReferenceType.Factory.newInstance();
        smsEpr.addNewAddress().setStringValue(url + "/StorageManagement" + "?res=default_storage");
        sc = new StorageClient(smsEpr, kernel.getClientConfiguration());
        
        sc.delete(testDir);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
        try{
        sc.delete(testDir);
        } catch (Exception e) {
            //ignored
        }
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testInitialise() throws Exception {
    }

    @Test
    public void testGetStorageAdapter() throws Exception {
    }
    
    @Test
    public void testGetName() throws Exception {
        System.out.println("Testing getName ");
        String storageName = sc.getStorageName();
        assertNotNull("Storage name should not be null",storageName);
    }
    
    @Test
    public void testGetFileSystem() throws Exception {
        System.out.println("Testing getFilesystem");
        FileSystemType fileSystem = sc.getFileSystem();
        assertNotNull("Filesystem should not be null", fileSystem);
    }

    @Test
    public void testListing() throws Exception {
        System.out.println("Testing file properties");
        
        sc.createDirectory(testDir);
        GridFileType[] ls = sc.listDirectory(testDir);
        for (int i = 0; i < ls.length; i++) {
            GridFileType gridFileType = ls[i];
            System.out.println("\t"+gridFileType);
            
        }
        assertEquals("New directory should be empty", 0, ls.length);
        GridFileType file = sc.listProperties(testDir);
        assertNotNull(file);
        System.out.println("Grid file: " + file);
        System.out.println("Path: " + file.getPath());
        assertTrue("Create in / ", file.getPath().equals(testDir));
        sc.delete(testDir);
    }

    @Test
    public void testCreateAndDelete() throws Exception {

        String testSubDir1 = testDir + "/dir1";
        String testSubDir2 = testDir + "/dir2";

        sc.createDirectory(testDir);
        sc.createDirectory(testSubDir1);
        GridFileType[] ls;
        ls = sc.listDirectory(testDir);
        assertEquals(1, ls.length);

        sc.createDirectory(testSubDir2);
        ls = sc.listDirectory(testDir);
        assertEquals(2, ls.length);

        sc.delete(testSubDir1);
        ls = sc.listDirectory(testDir);
        assertEquals(1, ls.length);

        sc.delete(testSubDir2);
        ls = sc.listDirectory(testDir);
        assertEquals(0, ls.length);

        sc.delete(testDir);
    }

    @Test
    public void testNullDir() throws Exception {
//        expect=Exception!
        GridFileType[] ls = sc.listDirectory("/randomDir");
    }

    @Test
    public void testRename() throws Exception {
        String subDir = testDir + "/dir1";
        String subDir2 = testDir + "/dir2";

        sc.createDirectory(testDir);
        sc.createDirectory(subDir);
        GridFileType[] ls = sc.listDirectory(testDir);
        assertEquals(1, ls.length);
        sc.rename(subDir, subDir2);
        GridFileType file = sc.listProperties(subDir2);
        assertNotNull(file);
        assertEquals(file.getPath(), subDir2);
        sc.delete(testDir);
    }

    @Test
    public void testSimpleCopy() throws Exception {
        sc.createDirectory(testDir);
        String subDir = testDir + "/dir1";
        String subDir2 = testDir + "/dir2";

        sc.createDirectory(subDir);
        GridFileType[] ls = sc.listDirectory(testDir);
        assertEquals(1, ls.length);


        sc.copy(subDir, subDir2);
        ls = sc.listDirectory(testDir);
        assertEquals(2, ls.length);
        GridFileType target = sc.listProperties(subDir2);
        assertNotNull(target);
        assertEquals(target.getPath(), subDir2);

        GridFileType source = sc.listProperties(subDir);
        assertNotNull(source);
        assertEquals(subDir, source.getPath());

        sc.delete(testDir);
    }

    @Test
    public void testImportExport() throws Exception {
        sc.createDirectory(testDir);
        String testFile = testDir + "/testFile.txt";

        FileTransferClient ftc = sc.getImport(testFile, ProtocolType.BFT);
        ByteArrayInputStream is = new ByteArrayInputStream("testdata".getBytes());
        ftc.writeAllData(is);
        is.close();
        ftc.destroy();
        //check the file exists
        GridFileType gf = sc.listProperties(testFile);
        assertNotNull(gf);
        assertTrue(gf.getSize() > 0);
        ftc = sc.getExport(testFile, ProtocolType.BFT);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ftc.readAllData(os);
        assertTrue("testdata".equals(os.toString()));
    }
}
