package de.fzj.unicore.uas.irods;

import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.xnjs.StorageAdapterFactory;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import java.io.IOException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSFileSystem;

public class IRodsStorageAdapterFactory implements StorageAdapterFactory {

    private static final long serialVersionUID = 1L;
    private final String storageRoot;

    public IRodsStorageAdapterFactory(String storageRoot) {
        this.storageRoot = storageRoot;
    }

    @Override
    public IStorageAdapter createStorageAdapter(UASWSResourceImpl parent) throws IOException {
//        Client client = parent.getClient();
//        Kernel kernel = parent.getKernel();
//        how to get properties:
//        String core = kernel.getProperty(SMSHadoopImpl.CONF_HADOOP_CORE, "conf/core-site.xml");
        
//        Kernel kernel = parent.getKernel();
        
        
        IRodsStorageAdapter storageAdapter;
        try {
            storageAdapter = new IRodsStorageAdapter(new IRODSFileSystem());            
            storageAdapter.setStorageRoot(storageRoot);
            return storageAdapter;
        } catch (JargonException ex) {
            throw new IOException("Unable to open iRODS file system", ex);
        }        
    }
    
    
}
