package de.fzj.unicore.uas.hadoop;

import static org.junit.Assert.assertTrue;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.services.atomic.types.ProtocolType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.sg.Registry;

/**
 * runs Hadoop SMS tests
 * 
 * @author schuller
 */
public class TestHadoopSMS {

	static String url;
	
	static StorageClient sc;

	static String configPath="src/test/resources/uas.config";
	
	@BeforeClass
	public static void initUNICORE() throws Exception {
		long start = System.currentTimeMillis();
		System.out.println("Starting UNICORE/X ...");
		
		//init the hadoop test cluster
		hadoopInit();
		
		FileUtils.deleteQuietly(new File("target","data"));
		
		//setup UAS
		UAS uas = new UAS(configPath);
		uas.startSynchronous();
		Kernel kernel=uas.getKernel();
		System.err.println("Startup time: "	+ (System.currentTimeMillis() - start) + " ms.");
		// create a "default" TSS - Target System Service
		Home h = kernel.getHome(UAS.TSS);
		Map<String, Object> initObj = new HashMap<String, Object>();
		initObj.put(UASWSResourceImpl.INIT_UNIQUE_ID, "default_targetsystem");
		h.createWSRFServiceInstance(initObj);
		
		url = kernel.getContainerProperties().getValue(ContainerProperties.WSRF_BASEURL);
		System.out.println("Creating StorageClient");
		EndpointReferenceType smsEpr = EndpointReferenceType.Factory
		.newInstance();
		smsEpr.addNewAddress().setStringValue(url + "/StorageManagement" + "?res=default_storage");
		sc = new StorageClient(smsEpr,kernel.getClientConfiguration());
		
	}
	
	static void hadoopInit()throws Exception{
		HadoopTestUtils.startTestCluster();
	}

	@AfterClass
	public static void stopHadoop(){
		HadoopTestUtils.shutdownTestCluster();
	}

	@Test
	public void testSMS() throws Exception{
		EndpointReferenceType epr;
		epr = EndpointReferenceType.Factory.newInstance();
		epr.addNewAddress().setStringValue(
				url + "/" + Registry.REGISTRY_SERVICE + "?res=default_registry");
		RegistryClient reg = new RegistryClient(epr,sc.getSecurityConfiguration());
		System.out.println("Listing available services "+StorageManagement.SMS_PORT);
		List<EndpointReferenceType> smss = reg.listServices(StorageManagement.SMS_PORT);
		for (int i = 0; i < smss.size(); i++) {
			System.out.println("Storage at address:" + smss.get(i).getAddress().getStringValue());
		}
		assertTrue(smss.size()>0);
	}

	@Test
	public void testCreateAndDelete() throws Exception{
		System.out.println("Testing directory handling");
		GridFileType[] ls=sc.listDirectory("/");
		assertTrue(0 == ls.length);
		
		sc.createDirectory("ABC");
		sc.createDirectory("XYZ");
		ls=sc.listDirectory("/");
		assertTrue(2 == ls.length);
		
		sc.delete("XYZ");
		ls=sc.listDirectory("/");
		assertTrue(1 == ls.length);
		
		sc.delete("ABC");
		ls=sc.listDirectory("/");
		assertTrue(0 == ls.length);
	}

	@Test
	public void testGetProperties() throws Exception{
		System.out.println("Testing file properties");
		sc.createDirectory("ABC");
		GridFileType[] ls=sc.listDirectory("/");
		assertTrue(1 == ls.length);
		GridFileType file=sc.listProperties("ABC");
		assertTrue(file!=null);
		assertTrue(file.getPath().equals("/ABC"));
		sc.delete("/ABC");
	}

	@Test
	public void testRename() throws Exception{
		System.out.println("Testing file rename");
		sc.createDirectory("ABC");
		GridFileType[] ls=sc.listDirectory("/");
		assertTrue(1 == ls.length);
		sc.rename("ABC", "DEF");
		GridFileType file=sc.listProperties("DEF");
		assertTrue(file!=null);
		assertTrue(file.getPath().equals("/DEF"));
		sc.delete("DEF");
	}

	@Test
	public void testSimpleCopy() throws Exception{
		System.out.println("Testing simple copy");
		sc.createDirectory("ABC");
		GridFileType[] ls=sc.listDirectory("/");
		assertTrue(1 == ls.length);
		sc.copy("ABC", "DEF");
		ls=sc.listDirectory("/");
		assertTrue(2 == ls.length);
		GridFileType file=sc.listProperties("DEF");
		assertTrue(file!=null);
		assertTrue(file.getPath().equals("/DEF"));
		sc.delete("DEF");
		file=sc.listProperties("ABC");
		assertTrue(file!=null);
		assertTrue(file.getPath().equals("/ABC"));
		sc.delete("ABC");
	}

	@Test
	public void testImportExport()throws Exception{
		FileTransferClient ftc=sc.getImport("/test", ProtocolType.BFT);
		ByteArrayInputStream is=new ByteArrayInputStream("testdata".getBytes());
		ftc.writeAllData(is);
		is.close();
		ftc.destroy();
		//check the file exists
		GridFileType gf=sc.listProperties("/test");
		assertTrue(gf!=null);
		assertTrue(gf.getSize()>0);
		ftc=sc.getExport("/test", ProtocolType.BFT);
		ByteArrayOutputStream os=new ByteArrayOutputStream();
		ftc.readAllData(os);
		assertTrue("testdata".equals(os.toString()));
	}	

	@Test
	public void testChmod()throws Exception{
		//TODO
	}

}
