package de.fzj.unicore.uas.hadoop;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * hadoop embedded setup and testing
 * 
 * @author schuller
 */
public class TestHadoop{

	@BeforeClass
	public static void startHadoop()throws Exception{
		HadoopTestUtils.startTestCluster();
	}
	
	@Test
	public void test1()throws Exception{
		MiniDFSCluster hdfs=HadoopTestUtils.getTestCluster();
		assertTrue(hdfs.isClusterUp());
		Configuration conf=new Configuration();
		//check that we can talk to the cluster
		FileSystem fs=FileSystem.get(conf);
		assertNotNull(fs);
		System.out.println("Filesystem impl: "+fs.getClass().getName());
		String name=fs.getHomeDirectory().getName();
		assertEquals(System.getProperty("user.name"),name);
	}

	
	@AfterClass
	public static void stopHadoop(){
		HadoopTestUtils.shutdownTestCluster();
	}

}
