package de.fzj.unicore.uas.hadoop;

import java.io.File;
import java.io.IOException;

import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsConstants.StartupOption;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class HadoopTestUtils {

	private static MiniDFSCluster hdfs=null;
	
	public static int nameNodePort=35906;
	
	public static void startTestCluster()throws IOException{
		//create storage dir -> see hadoop-site.xml
		new File("/tmp/hadoop/dfs/name").mkdirs();
		FileUtils.deleteQuietly(new File("/tmp/hadoop-"+System.getProperty("user.name")));
		String tmpdir="/tmp/hadoop-"+System.getProperty("user.name")+"/dfs/name";
		File dir=new File(tmpdir);
		FileUtils.deleteQuietly(dir);
		dir.mkdirs();
		//setup hadoop
		Configuration conf=new Configuration();
		NameNode.format(conf);
		hdfs=new MiniDFSCluster(nameNodePort, conf, 1, false, false, false,  StartupOption.FORMAT, null, null, null);
	}
	
	public static void shutdownTestCluster(){
		if(hdfs!=null)hdfs.shutdown();
	}
	
	public static MiniDFSCluster getTestCluster(){
		return hdfs;
	}

}
