/** Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.uas.hadoop;

import java.io.IOException;
import java.util.Map;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

import de.fzj.unicore.uas.impl.sms.FixedStorageImpl;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.StorageAdapterFactory;
import de.fzj.unicore.xnjs.io.IStorageAdapter;

/**
 * SMS adaptation for Hadoop 
 * 
 * @author Wasim Bari
 * @author schuller
 */
public class SMSHadoopImpl extends FixedStorageImpl {


	private static final Logger logger = LogUtil.getLogger(LogUtil.SERVICES, SMSBaseImpl.class);

	@Override
	public void initialise(String name, Map<String, Object> initobjs)throws Exception {
		logger.info("Initialising <"+getClass().getName()+">");
		super.initialise(name, initobjs);
		//TODO need to do proper file ownership checking -> see storage adapter ls()
	}

	private FileSystem getFS() throws IOException {
		Configuration conf = HadoopStorageAdapterFactory.getHadoopConfiguration(kernel);
		FileSystem fs= FileSystem.get(conf);
		fs.setWorkingDirectory(new Path(getStorageRoot()));
		return fs;
	}

	@Override
	public IStorageAdapter getStorageAdapter()throws Exception{
		HadoopStorageAdapter storageAdapter=new HadoopStorageAdapter(getFS(),getClient());
		return storageAdapter;
	}

	@Override
	protected StorageAdapterFactory getStorageAdapterFactory() {
		return new HadoopStorageAdapterFactory(getStorageRoot());
	}

	@Override
	protected String getSeparator(){
		return "/";
	}

}
