package de.fzj.unicore.uas.hadoop;

import java.io.File;
import java.io.IOException;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.xnjs.StorageAdapterFactory;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import eu.unicore.security.Client;

public class HadoopStorageAdapterFactory implements StorageAdapterFactory {

	private static final long serialVersionUID = 1L;

	private final String storageRoot;

	public HadoopStorageAdapterFactory(String storageRoot){
		this.storageRoot=storageRoot;
	}

	public IStorageAdapter createStorageAdapter(UASWSResourceImpl parent)throws IOException {
		Client client=parent.getClient();
		Kernel kernel=parent.getKernel();
		Configuration conf = getHadoopConfiguration(kernel);
		FileSystem fs= FileSystem.get(conf);
		fs.setWorkingDirectory(new Path(storageRoot));
		HadoopStorageAdapter storageAdapter=new HadoopStorageAdapter(fs,client);
		return storageAdapter;
	}
	
	public static Configuration getHadoopConfiguration(Kernel kernel)
	{
		HadoopProperties hadoopCfg = kernel.getAttribute(HadoopProperties.class);
		Configuration conf = new Configuration();
		String core = hadoopCfg.getValue(HadoopProperties.CONF_HADOOP_CORE);
		String hdfs = hadoopCfg.getValue(HadoopProperties.CONF_HADOOP_HDFS);;
		String mapred = hadoopCfg.getValue(HadoopProperties.CONF_HADOOP_MAPRED);
		conf.addResource(new Path(new File(core).toURI().toString()));
		conf.addResource(new Path(new File(hdfs).toURI().toString()));
		if(mapred!=null)conf.addResource(new Path(new File(mapred).toURI().toString()));
		return conf;
	}

}
