/*
 * Copyright (c) 2012 ICM Uniwersytet Warszawski All rights reserved.
 * See LICENCE.txt file for licensing information.
 */
package de.fzj.unicore.uas.hadoop;

import de.fzj.unicore.wsrflite.AbstractStartupTask;
import de.fzj.unicore.wsrflite.Kernel;

/**
 * Handles configuration initialization and checking at startup.
 * @author K. Benedyczak
 */
public class HadoopStartupTask extends AbstractStartupTask {
	@Override
	
	public void run() {
		Kernel kernel = getKernel();
		HadoopProperties hadoopCfg = new HadoopProperties(kernel.getContainerProperties().getRawProperties());
		kernel.addConfigurationHandler(HadoopProperties.class, hadoopCfg);
	}
}
