/*
 * Copyright (c) 2012 ICM Uniwersytet Warszawski All rights reserved.
 * See LICENCE.txt file for licensing information.
 */
package de.fzj.unicore.uas.hadoop;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.log4j.Logger;

import de.fzj.unicore.uas.UASProperties;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;

//FIXME - why hadoop is not configured with additional storage properties as other SMSes? 
//it is not uniform now.
public class HadoopProperties extends PropertiesHelper {
	private static final Logger log = Log.getLogger(Log.SERVICES, HadoopProperties.class);
	
	@DocumentationReferencePrefix
	public static final String PREFIX = UASProperties.PREFIX + "hadoop.";
	
	/**
	 * location of the core-site.xml config file
	 */
	public static final String CONF_HADOOP_CORE="core";

	/**
	 * location of the hdfs-site.xml config file
	 */
	public static final String CONF_HADOOP_HDFS="hdfs";

	/**
	 * location of the mapred-site.xml config file
	 */
	public static final String CONF_HADOOP_MAPRED="mapred";

	@DocumentationReferenceMeta
	public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();
	static {
		//TODO review me, add descriptions
		META.put(CONF_HADOOP_CORE, new PropertyMD("conf/ext-core-site.xml").setPath().
				setDescription("Core Hadoop configuration"));
		META.put(CONF_HADOOP_HDFS, new PropertyMD("conf/hdfs-site.xml").setPath().
				setDescription("Site's Hadoop configuration"));
		META.put(CONF_HADOOP_MAPRED, new PropertyMD((String)null).setPath().
				setDescription(""));
	}
	
	public HadoopProperties(Properties properties) throws ConfigurationException {
		super(PREFIX, properties, META, log);
	}
}
