/*
 * Copyright (c) 2011 ICM Uniwersytet Warszawski All rights reserved.
 * See LICENCE file for licencing information.
 *
 * Created on 03-08-2011
 * Author: K. Benedyczak <golbi@mat.umk.pl>
 */
package de.fzj.unicore.uas.hadoop;

import org.apache.hadoop.fs.permission.ChmodParser;
import org.apache.hadoop.fs.permission.FsPermission;

public class ChmodParser2 extends ChmodParser {

	public ChmodParser2(String modeStr) throws IllegalArgumentException {
		super(modeStr);
	}

	/**
	 * Apply permission against specified perms and determine what the new
	 * mode would be
	 * 
	 * @param perms current perms
	 * @param dir whether file is a directory
	 * @return File's new mode if applied.
	 */
	public short applyNewPermission(FsPermission perms, boolean dir) {
		int existing = perms.toShort();
		boolean exeOk = dir || (existing & 0111) != 0;
		return (short) combineModes(existing, exeOk);
	}
}
